/*
 * Decompiled with CFR 0.152.
 */
package net.starschema.clouddb.jdbc.list;

import java.util.List;
import net.starschema.clouddb.jdbc.JdbcGrammarParser;
import net.starschema.clouddb.jdbc.antlr.sqlparse.ColumnCallException;
import net.starschema.clouddb.jdbc.antlr.sqlparse.TreeParsingException;
import net.starschema.clouddb.jdbc.list.ColumnCall;
import net.starschema.clouddb.jdbc.list.ColumnReference;
import net.starschema.clouddb.jdbc.list.Expression;
import net.starschema.clouddb.jdbc.list.FromExpression;
import net.starschema.clouddb.jdbc.list.JoinType;
import net.starschema.clouddb.jdbc.list.Node;
import net.starschema.clouddb.jdbc.list.OnClause;
import net.starschema.clouddb.jdbc.list.OnClauseCondition;
import net.starschema.clouddb.jdbc.list.Resolver;
import net.starschema.clouddb.jdbc.list.SelectStatement;
import net.starschema.clouddb.jdbc.list.SourceTable;
import net.starschema.clouddb.jdbc.list.SubQuery;
import net.starschema.clouddb.jdbc.list.TreeBuilder;
import org.antlr.runtime.tree.Tree;

public class JoinExpression
extends Node {
    Node leftItem;
    Node rightItem;
    JoinType type = null;
    OnClause onClause = null;
    boolean each = false;
    SelectStatement selectStatement;
    TreeBuilder builder;

    public JoinExpression(Tree t, TreeBuilder treeBuilder, SelectStatement selectStatement) throws TreeParsingException, ColumnCallException {
        this.builder = treeBuilder;
        this.selectStatement = selectStatement;
        this.build(t, this.builder);
    }

    public JoinExpression(SubQuery leftItem, Tree t, TreeBuilder treeBuilder, SelectStatement selectStatement) throws TreeParsingException, ColumnCallException {
        this.builder = treeBuilder;
        this.selectStatement = selectStatement;
        this.leftItem = leftItem;
        leftItem.setisPartOfJoin();
        this.build(t, this.builder);
    }

    public JoinExpression(TreeBuilder builder, Node leftItem, Node rightItem, OnClause onClause, SelectStatement selectStatement) {
        SubQuery subQuery;
        this.selectStatement = selectStatement;
        this.builder = builder;
        this.leftItem = leftItem;
        this.rightItem = rightItem;
        if (leftItem.tokenType == 126) {
            subQuery = (SubQuery)SubQuery.class.cast(leftItem);
            subQuery.setisPartOfJoin();
        }
        if (rightItem.tokenType == 126) {
            subQuery = (SubQuery)SubQuery.class.cast(rightItem);
            subQuery.setisPartOfJoin();
        }
        this.onClause = onClause;
        this.tokenType = 71;
        this.tokenName = JdbcGrammarParser.tokenNames[71];
    }

    public void build(Tree t, TreeBuilder builder) throws TreeParsingException, ColumnCallException {
        if (t.getType() == 71 || t.getType() == 91) {
            Tree child;
            int i;
            this.tokenName = JdbcGrammarParser.tokenNames[t.getType()];
            this.tokenType = t.getType();
            this.logger.debug("BUILDING " + this.tokenName);
            block22: for (i = 0; i < t.getChildCount(); ++i) {
                child = t.getChild(i);
                switch (child.getType()) {
                    case 79: {
                        String newalias;
                        SubQuery mySubQuery;
                        SelectStatement mySelectStatement;
                        Expression expression;
                        FromExpression fromexpression;
                        List<ColumnCall> columnlist;
                        String alias;
                        SourceTable tablenode;
                        Resolver resolve;
                        SubQuery subQuery;
                        switch (child.getChild(0).getType()) {
                            case 126: {
                                subQuery = new SubQuery(child.getChild(0), builder);
                                subQuery.setisPartOfJoin();
                                this.leftItem = subQuery;
                                continue block22;
                            }
                            case 124: {
                                resolve = new Resolver(builder);
                                tablenode = new SourceTable(child.getChild(0), builder);
                                alias = tablenode.getAlias();
                                columnlist = resolve.parseSrcTableForJokers(tablenode);
                                this.logger.debug("got columns");
                                tablenode.alias = null;
                                fromexpression = new FromExpression(tablenode, builder);
                                expression = new Expression(columnlist, builder);
                                mySelectStatement = new SelectStatement(expression, fromexpression, builder);
                                expression.setSelectStatement(mySelectStatement);
                                mySubQuery = null;
                                if (alias != null) {
                                    mySubQuery = new SubQuery(alias, builder, mySelectStatement);
                                } else {
                                    newalias = "";
                                    if (tablenode.getDataset() != null) {
                                        newalias = newalias + tablenode.getDataset() + ".";
                                    }
                                    newalias = newalias + tablenode.getName();
                                    mySubQuery = new SubQuery(newalias, builder, mySelectStatement);
                                }
                                mySubQuery.setisPartOfJoin();
                                this.leftItem = mySubQuery;
                                continue block22;
                            }
                        }
                        continue block22;
                    }
                    case 114: {
                        String newalias;
                        SubQuery mySubQuery;
                        SelectStatement mySelectStatement;
                        Expression expression;
                        FromExpression fromexpression;
                        List<ColumnCall> columnlist;
                        String alias;
                        SourceTable tablenode;
                        Resolver resolve;
                        SubQuery subQuery;
                        switch (child.getChild(0).getType()) {
                            case 126: {
                                subQuery = new SubQuery(child.getChild(0), builder);
                                subQuery.setisPartOfJoin();
                                this.rightItem = subQuery;
                                continue block22;
                            }
                            case 124: {
                                resolve = new Resolver(builder);
                                tablenode = new SourceTable(child.getChild(0), builder);
                                alias = tablenode.getAlias();
                                columnlist = resolve.parseSrcTableForJokers(tablenode);
                                this.logger.debug("got columns");
                                tablenode.alias = null;
                                fromexpression = new FromExpression(tablenode, builder);
                                expression = new Expression(columnlist, builder);
                                mySelectStatement = new SelectStatement(expression, fromexpression, builder);
                                expression.setSelectStatement(mySelectStatement);
                                mySubQuery = null;
                                if (alias != null) {
                                    mySubQuery = new SubQuery(alias, builder, mySelectStatement);
                                } else {
                                    newalias = "";
                                    if (tablenode.getDataset() != null) {
                                        newalias = newalias + tablenode.getDataset() + ".";
                                    }
                                    newalias = newalias + tablenode.getName();
                                    mySubQuery = new SubQuery(newalias, builder, mySelectStatement);
                                }
                                mySubQuery.setisPartOfJoin();
                                this.rightItem = mySubQuery;
                                continue block22;
                            }
                        }
                        continue block22;
                    }
                    case 73: {
                        switch (child.getChild(0).getType()) {
                            case 80: {
                                this.type = JoinType.LEFT;
                                break;
                            }
                            case 115: {
                                this.type = JoinType.RIGHT;
                                break;
                            }
                            case 52: {
                                this.type = JoinType.FULL;
                                break;
                            }
                            case 65: {
                                this.type = JoinType.INNER;
                                break;
                            }
                        }
                        if (child.getChild(1).getType() != 42) continue block22;
                        this.each = true;
                        continue block22;
                    }
                }
            }
            block23: for (i = 0; i < t.getChildCount(); ++i) {
                child = t.getChild(i);
                switch (child.getType()) {
                    case 101: {
                        this.onClause = new OnClause(child, builder, this.selectStatement);
                        continue block23;
                    }
                }
            }
            for (Node condition : this.onClause.children) {
                OnClauseCondition onClauseCondition = (OnClauseCondition)OnClauseCondition.class.cast(condition);
                ColumnReference left = onClauseCondition.left;
                ColumnReference right = onClauseCondition.right;
                left.setPointedNode(left.searchPointedNodeInSubQuery((SubQuery)this.leftItem));
                if (left.getPointedNode() == null) {
                    left.setPointedNode(left.searchPointedNodeInSubQuery((SubQuery)this.rightItem));
                }
                right.setPointedNode(right.searchPointedNodeInSubQuery((SubQuery)this.leftItem));
                if (right.getPointedNode() != null) continue;
                right.setPointedNode(right.searchPointedNodeInSubQuery((SubQuery)this.rightItem));
            }
        } else {
            throw new TreeParsingException("This Tree is not an JOINEXPRESSION");
        }
    }

    public Node getLeftItem() {
        return this.leftItem;
    }

    public OnClause getOnclause() {
        return this.onClause;
    }

    public Node getRightItem() {
        return this.rightItem;
    }

    public JoinType getjointype() {
        return this.type;
    }

    @Override
    public String toPrettyString() {
        return this.toPrettyString(-1);
    }

    @Override
    public String toPrettyString(int level) {
        int newlevel = level < 0 ? -1 : level + 1;
        String result = "";
        result = result + this.leftItem.toPrettyString(newlevel);
        result = this.type != null ? result + " " + this.type.toString() + newline + this.tab(newlevel) + " JOIN " + newline : result + newline + this.tab(level + 1) + (this.each ? " JOIN EACH " : " JOIN ") + newline;
        result = result + this.rightItem.toPrettyString(newlevel);
        result = result + newline + this.onClause.toPrettyString(newlevel);
        return result;
    }
}

