\name{confint}
\alias{confint.DTRreg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Flexible Confidence Interval Calculations for DTRs}
%%  ~~function to do ... ~~
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Confidence intervals for dWOLS or DWSurv parameters, with the possibility of deriving constructing the confidence intervals using the percentile method when bootstrap is used (DWSurv only).
}
\usage{
\method{confint}{DTRreg}(object, parm = NULL, level = 0.95, type = "se", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{A model object generated by the function DTRreg.}
  \item{type}{Typical Wald-type confidence interval "se" (default) or confidence intervals derived with the percentile method "percentile" (currently available with dWSurv only).}
  \item{parm}{Not available for DTRreg objects.}
  \item{level}{the confidence level required.}
  \item{\dots}{Space for additional arguments (not currently used by DTRreg).}
}
\value{
A list with columns giving lower and upper confidence limits for each parameter. These will be labelled as (1-level)/2 and 1 - (1-level)/2 in % (by default 2.5% and 97.5%).
}
\references{
Simoneau G, Moodie EE, Wallace MP, Platt RW. Optimal dynamic treatment regimes with survival endpoints: introducing DWSurv in the R package DTRreg. Journal of Statistical Computation and Simulation. 2020 Jul 16:1-8.%% ~put references to the literature/web site here ~
}
\author{
Gabrielle Simoneau%%  ~~who you are~~
}
\examples{
##################
# simulate data
expit <- function(x) exp(x) / (1 + exp(x))
theta1 <- c(4.7, 1.5, -0.8, 0.1, 0.1)
n <- 100
X1 <- runif(n, 0.1, 1.29) 
X12 <- rbinom(n, 1, 0.4)
A1 <- rbinom(n, 1, expit(2*X1 - 1))
delta <- rbinom(n, 1, expit(3*X12 + 0.1))
logT <- theta1[1] + theta1[2]*X1[delta == 1] + theta1[3]*X12[delta == 1] + 
theta1[4]*A1[delta == 1] + theta1[5]*A1[delta == 1]*X1[delta == 1] + 
rnorm(sum(delta), sd = 0.3)

C <- rexp(n - sum(delta), rate = 1/300)
Y <- rep(NA, n)
Y[delta == 1] <- exp(logT)
Y[delta == 0] <- C

dataset <- data.frame(X1, X12, A1, delta, Y)

model <- DWSurv(time = list(~Y), blip.mod = list(~X1), treat.mod = list(A1~X1), 
tf.mod = list(~X1 + X12), cens.mod = list(delta~X12), data = dataset, var.estim = "bootstrap", 
boot.opt = "standard", B = 200)
confint(model, type = "percentile")
#################
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\concept{dynamic treatment regimens}
\concept{adaptive treatment strategies}
\concept{personalized medicine}
\concept{g-estimation}
\concept{dynamic weighted ordinary least squares}
