% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_filet.R
\name{write_filet}
\alias{write_filet}
\title{Writes data to a single DSSAT file T}
\usage{
write_filet(filet, file_name, drop_duplicate_rows = TRUE)
}
\arguments{
\item{filet}{a tibble containing the data to write to a DSSAT file T}

\item{file_name}{a character vector of length one that contains the name
of a single DSSAT file into which `filet` will be written}

\item{drop_duplicate_rows}{a logical value indicating whether duplicate rows
should be dropped from tier_data}
}
\description{
Writes data to a single DSSAT file T
}
\examples{

# Extract FileT path for sample file
sample_filet <- system.file('extdata','SAMPLE.CRT',package='DSSAT')

filet <- read_filet(sample_filet)

# Create example FileT file path
sample_filet2 <- paste0(tempdir(),'/SAMPLE.CRT')

# Write out sample FileA
write_filet(filet,sample_filet2)

}
