#' Basic Virus Model
#' 
#' @description A basic virus infection model with 3 compartments
#' 
#' @details The model includes uninfected and infected target cells, as well as free virus. The processes that are modeled are infection, virus production, uninfected cell birth and death, infected cell and virus death.
#' 
#' This code was generated by the modelbuilder R package.  
#' The model is implemented as a set of ordinary differential equations using the deSolve package. 
#' The following R packages need to be loaded for the function to work: deSolve. 
#' 
#' @param U : starting value for Uninfected cells : numeric
#' @param I : starting value for Infected cells : numeric
#' @param V : starting value for Virus : numeric
#' @param n : rate of new uninfected cell replenishment : numeric
#' @param dU : rate at which uninfected cells die : numeric
#' @param dI : rate at which infected cells die : numeric
#' @param dV : rate at which virus is cleared : numeric
#' @param b : rate at which virus infects cells : numeric
#' @param p : rate at which infected cells produce virus : numeric
#' @param g : possible conversion factor for virus units : numeric
#' @param tstart : Start time of simulation : numeric
#' @param tfinal : Final time of simulation : numeric
#' @param dt : Time step : numeric
#' @return The function returns the output as a list. 
#' The time-series from the simulation is returned as a dataframe saved as list element \code{ts}. 
#' The \code{ts} dataframe has one column per compartment/variable. The first column is time.   
#' @examples  
#' # To run the simulation with default parameters:  
#' result <- simulate_Basic_Virus_Model_ode() 
#' # To choose values other than the standard one, specify them like this:  
#' result <- simulate_Basic_Virus_Model_ode(U = 2e+05,I = 0,V = 2) 
#' # You can display or further process the result, like this:  
#' plot(result$ts[,'time'],result$ts[,'U'],xlab='Time',ylab='Numbers',type='l') 
#' print(paste('Max number of U: ',max(result$ts[,'U']))) 
#' @section Warning: This function does not perform any error checking. So if you try to do something nonsensical (e.g. have negative values for parameters), the code will likely abort with an error message.
#' @section Model Author: Andreas Handel
#' @section Model creation date: 2021-07-19
#' @section Code Author: generated by the \code{modelbuilder} R package 
#' @section Code creation date: 2021-07-19
#' @export 
 
simulate_Basic_Virus_Model_ode <- function(U = 1e+05, I = 0, V = 1, n = 0, dU = 0, dI = 1, dV = 2, b = 2e-05, p = 5, g = 1, tstart = 0, tfinal = 30, dt = 0.1) 
{ 
  ############################## 
  #Block of ODE equations for deSolve 
  ############################## 
  Basic_Virus_Model_ode_fct <- function(t, y, parms) 
  {
    with( as.list(c(y,parms)), { #lets us access variables and parameters stored in y and parms by name 
    #StartODES
    #Uninfected cells : Uninfected cell birth : Uninfected cell death : Infection of cells :
    dU_mb = +n -dU*U -b*V*U
    #Infected cells : infection of cells : death of infected cells :
    dI_mb = +b*V*U -dI*I
    #Virus : virus production : virus removal : infection of cells :
    dV_mb = +p*I -dV*V -b*g*V*U
    #EndODES
    list(c(dU_mb,dI_mb,dV_mb)) 
  } ) } #close with statement, end ODE code block 
 
  ############################## 
  #Main function code block 
  ############################## 
  #Creating named vectors 
  varvec_mb = c(U = U, I = I, V = V) 
  parvec_mb = c(n = n, dU = dU, dI = dI, dV = dV, b = b, p = p, g = g) 
  timevec_mb = seq(tstart, tfinal,by = dt) 
  #Running the model 
  simout = deSolve::ode(y = varvec_mb, parms = parvec_mb, times = timevec_mb,  func = Basic_Virus_Model_ode_fct, rtol = 1e-12, atol = 1e-12) 
  #Setting up empty list and returning result as data frame called ts 
  result <- list() 
  result$ts <- as.data.frame(simout) 
  return(result) 
} 
