% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_plotly.R
\name{generate_plotly}
\alias{generate_plotly}
\title{A helper function that takes simulation results and produces plotly plots}
\usage{
generate_plotly(res)
}
\arguments{
\item{res}{A list structure containing all simulation results that are to be plotted.
The length of the list indicates the number of separate plots to make.
Each list entry corresponds to one plot and
needs to contain the following information/elements: \cr
1. A data frame called "dat" or "ts". If the data frame is "ts" it is assumed to be
a time series and by default a line plot will be produced and labeled Time/Numbers.
For plotting, the data needs to be in a format with one column called xvals, one column yvals,
one column called varnames that contains names for different variables.
Varnames needs to be a factor variable or will be converted to one.
If a column 'varnames' exist, it is assumed the data is in the right format. Otherwise it will be transformed.
An optional column called IDvar can be provided for further grouping (i.e. multiple lines for stochastic simulations).
If plottype is 'mixedplot' an additional column called 'style' indicating line or point plot
for each variable is needed. \cr
2. Meta-data for the plot, provided in the following variables: \cr
optional: plottype - One of "Lineplot" (default is nothing is provided),"Scatterplot","Boxplot", "Mixedplot". \cr
optional: xlab, ylab - Strings to label axes. \cr
optional: xscale, yscale - Scaling of axes, valid ggplot expression, e.g. "identity" or "log10". \cr
optional: xmin, xmax, ymin, ymax - Manual min and max for axes. \cr
optional: makelegend - TRUE/FALSE, add legend to plot. Assume true if not provided. \cr
optional: legendtitle - Legend title, if NULL/not supplied, default is used \cr
optional: legendlocation - if "left" is specified, top left. Otherwise top right. \cr
optional: linesize - Width of line, numeric, i.e. 1.5, 2, etc. set to 1.5 if not supplied. \cr
optional: title - A title for each plot. \cr
optional: for multiple plots, specify res[[1]]$ncols to define number of columns \cr}
}
\value{
A plotly plot structure for display in a Shiny UI.
}
\description{
This function generates plots to be displayed in the Shiny UI.
This is a helper function. This function processes results returned from the simulation, supplied as a list.
}
\details{
This function is called by the Shiny server to produce plots returned to the Shiny UI.
Create plots run the simulation with default parameters just call the function:
result <- simulate_basicbacteria()
plot <- generate_plotly(result)
}
\author{
Yang Ge, Andreas Handel
}
