% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drdid_imp_panel.R
\name{drdid_imp_panel}
\alias{drdid_imp_panel}
\title{Improved locally efficient doubly robust DiD estimator for the ATT, with panel data}
\usage{
drdid_imp_panel(
  y1,
  y0,
  D,
  covariates,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE,
  trim.level = 0.995
)
}
\arguments{
\item{y1}{An \eqn{n} x \eqn{1} vector of outcomes from the post-treatment period.}

\item{y0}{An \eqn{n} x \eqn{1} vector of outcomes from the pre-treatment period.}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the propensity score and regression estimation. Please add a vector of constants if you want to include an intercept in the models.
If covariates = NULL, this leads to an unconditional DiD estimator.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights. The weights are normalized and therefore enforced to have mean 1 across all observations.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}

\item{trim.level}{The level of trimming for the propensity score. Default is 0.995.}
}
\value{
A list containing the following components:
 \item{ATT}{The DiD point estimate.}
 \item{se}{The DiD standard error.}
 \item{uci}{The upper bound of the 95\% CI for the ATT.}
 \item{lci}{The lower bound of the 95\% CI for the ATT}
 \item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is \code{NULL}.}
 \item{ps.flag}{Convergence Flag for the propensity score estimation: =0 if \code{trust} algorithm converged,
   =1 if IPW algorithm converged (in case it was used), =2 if GLM logit estimator was used (i.e., if both \code{trust} and IPT
   did not converged).}
 \item{att.inf.func}{Estimate of the influence function. Default is NULL}
 \item{call.param}{The matched call.}
 \item{argu}{Some arguments used (explicitly or not) in the call (panel = TRUE, estMethod = "imp", boot, boot.type, nboot, type="dr")}
}
\description{
\code{drdid_imp_panel} is used to compute the locally efficient doubly robust estimators for the ATT
 in difference-in-differences (DiD) setups with panel data. The resulting estimator is also doubly robust
 for inference; see Section 3.1 of Sant'Anna and Zhao (2020).
}
\details{
The \code{drdid_imp_panel} function implements the locally efficient doubly robust difference-in-differences (DiD)
estimator for the average treatment effect on the treated (ATT) defined in equation (3.1)
in Sant'Anna and Zhao (2020). This estimator makes use of a logistic propensity score model for the probability
of being in the treated group, and of a linear regression model for the outcome evolution among the comparison units.


The nuisance parameters (propensity score and outcome regression parameters) are estimated using the methods
described in Sections 3.1 of Sant'Anna and Zhao (2020). In short, the propensity score parameters are estimated
using the inverse probability tilting estimator proposed by Graham, Pinto and Pinto (2012), and the outcome
regression coefficients are estimated using weighted least squares,where the weights depend on
the propensity score estimates; see Sant'Anna and Zhao (2020) for details.


The resulting estimator is not only locally efficient and doubly robust for the ATT,
but it is also doubly robust for inference; see Sant'Anna and Zhao (2020) for details.
}
\examples{
# Form the Lalonde sample with CPS comparison group
eval_lalonde_cps <- subset(nsw, nsw$treated == 0 | nsw$sample == 2)
# Further reduce sample to speed example
set.seed(123)
unit_random <- sample(1:nrow(eval_lalonde_cps), 5000)
eval_lalonde_cps <- eval_lalonde_cps[unit_random,]
# Select some covariates
covX = as.matrix(cbind(1, eval_lalonde_cps$age, eval_lalonde_cps$educ,
                             eval_lalonde_cps$black, eval_lalonde_cps$married,
                             eval_lalonde_cps$nodegree, eval_lalonde_cps$hisp,
                             eval_lalonde_cps$re74))

# Implement improved DR locally efficient DiD with panel data
drdid_imp_panel(y1 = eval_lalonde_cps$re78, y0 = eval_lalonde_cps$re75,
                D = eval_lalonde_cps$experimental,
                covariates = covX)

}
\references{
\cite{Graham, Bryan, Pinto, Cristine, and Egel, Daniel (2012),
"Inverse Probability Tilting for Moment Condition Models with Missing Data."
 Review of Economic Studies, vol. 79 (3), pp. 1053-1079, \doi{10.1093/restud/rdr047}}


\cite{Sant'Anna, Pedro H. C. and Zhao, Jun. (2020),
"Doubly Robust Difference-in-Differences Estimators." Journal of Econometrics, Vol. 219 (1), pp. 101-122,
\doi{10.1016/j.jeconom.2020.06.003}}
}
