% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rmp.R
\name{rmp}
\alias{rmp}
\title{Random match probability of profile(s)}
\usage{
rmp(x, freqs = get.freqs(x), markers = get.markers(x), theta = 0,
  cmp = FALSE, ret.per.marker = FALSE)
}
\arguments{
\item{x}{Integer matrix with the profile(s) for which random match probability is computed.}

\item{freqs}{A list specifying the allelic frequencies. Should contain a vector of allelic frequencies for each locus, named after that locus.}

\item{markers}{Character vector stating the markers to use in the rmp computation. Defaults to all markers of the profile.}

\item{theta}{Numeric value specifying the amount of background relatedness.}

\item{cmp}{Logical conditional match probability. If TRUE, the Balding-Nichols formula is used to compute the conditional match probability in the same subpopulation.}

\item{ret.per.marker}{Logical. If TRUE, return a matrix of random match probabilities, where the columns correspond to markers.}
}
\value{
numeric matrix of random match probabilities. When \code{ret.per.matrix} is \code{TRUE}, the columns contain rmps per marker.
}
\description{
Computes the random/conditional match probability.
}
\details{
When \eqn{\theta=0}, the simple product rule is used. Assuming Hardy-Weinberg and Linkage Equilibrium, the random match probability (rmp) for unordered is computed as the product of \deqn{2^H f_a f_b} over the loci, where \eqn{f_a} and \eqn{f_b} are respectively the population frequencies of allele \eqn{a} and \eqn{b} and \eqn{H} is the indicator function for heterozygosity (alleles \eqn{a} and \eqn{b} are not the same).

         When \eqn{\theta>0} and \code{cmp=FALSE}, the product rule is used that incorporates a correction for inbreeding as measured by \eqn{theta}.

         When \eqn{\theta>0} and \code{cmp=TRUE}, a product rule involving a subpopulation correction is used, as given by Balding & Nichols. The match probability for homozygotes is given by: \deqn{\frac{(2 \theta+(1-\theta)f_a)(3 \theta+(1-\theta)f_a)}{(1+\theta)(1+2 \theta)},}and for heterozygotes by: \deqn{\frac{2(\theta+(1-\theta)f_a)(\theta+(1-\theta)f_b)}{(1+\theta)(1+2\theta)}.}

         If \code{x} contains missing values (NAs) at a marker, then the returned match probability equals one for persons with both alleles missing. If a single allele is missing, then the match probability is equal to the frequency of the single allele that is seen, unless the conditional match probability is computed.
}
\examples{
## compute the conditional match probability for two markers
data(freqsNLngm)
y <- sample.profiles(N=1,freqsNLngm)
rmp(y,markers = c("FGA","TH01"),theta=0.03,cmp=TRUE,ret.per.marker = TRUE)
rmp(y,markers = c("FGA","TH01"),ret.per.marker = TRUE) # compare to product rule estimate

## make a plot of density estimates of RMPs of profiles on the 10 SGMplus

data(freqsNLsgmplus)

#sample profiles
x <- sample.profiles(N=1e3,freqsNLsgmplus)

#compute RMPs
x.rmp <- rmp(x)

 plot(density(log10(x.rmp)),
    xlab=expression(log[10](RMP)),
    main="Random match probabilities for SGMplus profiles")
}

