% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_Plotting.R
\name{Pplot2}
\alias{Pplot2}
\title{A projection by projection plot of F/FMSY, B/BMSY, B/B0, and yield}
\usage{
Pplot2(MSEobj, YVar = c("F_FMSY", "SSB_SSBMSY"), MPs = NA, sims = NULL,
  traj = c("all", "quant"), quants = c(0.1, 0.9), incquant = TRUE,
  quantcol = "lightgray", RefYield = c("lto", "curr"), LastYr = TRUE,
  maxMP = 6, alpha = 60, cex.axis = 1, cex.lab = 1, YLab = NULL,
  incMP = TRUE, MPcex = 1, incLeg = TRUE, cex.leg = 1.5,
  legPos = "topleft", yline = NULL, parOR = FALSE, xaxis = TRUE,
  yaxis = TRUE, oneIt = TRUE, ...)
}
\arguments{
\item{MSEobj}{An object of class MSE}

\item{YVar}{What to plot on the y-axis? Options are: \code{c('SSB_SSB0',
'SSB_SSBMSY', 'F_FMSY', 'Yield')}}

\item{MPs}{Optional subset by MP}

\item{sims}{Optional subset by simulation}

\item{traj}{Plot all projections (\code{all}) or only quantiles
(\code{quant})}

\item{quants}{Numeric vector of length 2 specifying the quantiles (e.g.,
10th and 90th. Median is always included)}

\item{incquant}{Logical. Include the quantiles or only plot median?}

\item{quantcol}{Colour of the quantile polygon}

\item{RefYield}{Should yield be relative to long-term optimum (\code{lto})
or last historical year (\code{curr})}

\item{LastYr}{Logical. Include the last historical year in the yield
projections?}

\item{maxMP}{Maximum number of MPs to plot}

\item{alpha}{Alpha for transparency of lines}

\item{cex.axis}{Size of axis text}

\item{cex.lab}{Size of axis label}

\item{YLab}{Optional label for y-axis}

\item{incMP}{Logical. Include name of MP?}

\item{MPcex}{Size of MP label}

\item{incLeg}{Logical. Include a legend?}

\item{cex.leg}{Size of legend text}

\item{legPos}{Legend position}

\item{yline}{Optional horizontal line}

\item{parOR}{Logical to over-ride the par parameters}

\item{xaxis}{Logical. Should x-axis labels be displayed?}

\item{yaxis}{Logical. Should y-axis labels be displayed?}

\item{oneIt}{Logical. Should one iteration be plotted on the quantile plot?}

\item{...}{Additional arguments to be passed to plotting functions}
}
\description{
A projection by projection plot of F/FMSY, B/BMSY, B/B0, and yield
}
\author{
T. Carruthers & A.Hordyk
}
