% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformQuantiles.R
\name{transformQuantiles}
\alias{transformQuantiles}
\title{Transform quantiles to pdf}
\usage{
transformQuantiles(res, quantileFunction = qnorm, outlierValue = 7)
}
\arguments{
\item{res}{DHARMa residuals}

\item{quantileFunction}{the quantile function of the desired distribution}

\item{outlierValue}{the value that should be assigned to residuals that are 0/1 and thus typically mapped to -Inf / Inf for continous distributions with infinte support}
}
\description{
The purpose of this function is to transform the DHARMa quantile residuals (which have a uniform distribution) to a particular pdf.
}
\details{
Some of the papers on simulated quantile residuals transforming the residuals (which are natively uniform) back to a normal distribution. I presume this is because of the larger familiarity of most users with normal residuals. Personally, I never considered this desirable, for the reasons explained in https://github.com/florianhartig/DHARMa/issues/39, but with this function, I wanted to give users the option to plot normal residuals if they so wish.
}
\examples{

set.seed(1)
testData = createData(sampleSize = 200, family = poisson())
fittedModel <- glm(observedResponse ~ Environment1, 
                     family = "poisson", data = testData)
res <- simulateResiduals(fittedModel = fittedModel)
plot(res$fittedPredictedResponse, transformQuantiles(res))

}
