% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flame.R
\name{getFlame}
\alias{getFlame}
\title{Get the shape of a single flame}
\usage{
getFlame(faces = 10, radius = 0.3, dz = 1, z.exp = 1.1, expand = 1,
  turn = 0)
}
\arguments{
\item{faces}{number of side and height}

\item{radius}{maximum width}

\item{dz}{increase in height per z-side}

\item{z.exp}{exponetial z factor}

\item{expand}{linear width (x/y) expend factor with height}

\item{turn}{twist the flame a bit}
}
\value{
list of vertices and ids to be used with rgl::triangles3d
}
\description{
Get the shape of a single flame
}
\examples{
\dontrun{
center = getFlame(dz=0.8)
triangles3d(center$vertices[center$id[, (2 * 20 + 1):150], ],
            col="#e6ffff", alpha=1, shininess=1,lit=FALSE)
inner = getFlame(dz=0.97, expand=2)
triangles3d(inner$vertices[inner$id[, (2 * 20 + 1):175], ],
            col="#f0ff00", alpha=0.6, shininess=1,lit=FALSE)
outer = getFlame(dz=1, expand=3)
triangles3d(outer$vertices[outer$id[, (2*20+1):200], ],
            col="#ce1301", alpha=0.3,shininess=10,lit=FALSE)
}
}
