% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{getBaseType}
\alias{getBaseType}
\title{Retrieve data items by baseType}
\usage{
getBaseType(dgeObj, baseType)
}
\arguments{
\item{dgeObj}{A DGEobj}

\item{baseType}{One or more of: ["row", "col", "assay", "meta"]}
}
\value{
A list of data items
}
\description{
Retrieve data items by baseType
}
\examples{
    # example DGEobj
    exObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))

    Assays <- getBaseType(exObj, baseType = "assay")
    AssaysAndMeta <- getBaseType(exObj, c("assay", "meta"))

}
