% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dEploidPlotly.R
\name{plotObsExpWSAFPlotly}
\alias{plotObsExpWSAFPlotly}
\title{Plot WSAF}
\usage{
plotObsExpWSAFPlotly(obsWSAF, expWSAF, title = "WSAF(observed vs expected)")
}
\arguments{
\item{obsWSAF}{Numeric array of observed WSAF.}

\item{expWSAF}{Numeric array of expected WSAF.}

\item{title}{Figure title, "WSAF(observed vs expected)" by default}
}
\description{
Plot observed alternative allele frequency within sample against
 expected WSAF.
}
\examples{
\dontrun{
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV = extractCoverageFromVcf(vcfFile)
obsWSAF = computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)
plafFile = system.file("extdata", "labStrains.test.PLAF.txt",
 package = "DEploid")
PG0390CoverageV.deconv = dEploid(paste("-vcf", vcfFile,
                                       "-plaf", plafFile, "-noPanel"))

prop = PG0390CoverageV.deconv$Proportions[dim(PG0390CoverageV.deconv
                                              $Proportions)[1],]

expWSAF = t(PG0390CoverageV.deconv$Haps) \%*\% prop
plotObsExpWSAFPlotly(obsWSAF, expWSAF)
}

}
