% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{extractCoverageFromVcf}
\alias{extractCoverageFromVcf}
\title{Extract read counts from VCF}
\usage{
extractCoverageFromVcf(vcfFileName, ADFieldIndex = 2)
}
\arguments{
\item{vcfFileName}{Path of the VCF file.}

\item{ADFieldIndex}{Index of the AD field of the sample field. For example,
if the format is "GT:AD:DP:GQ:PL", the AD index is 2 (by default).}
}
\value{
A data.frame contains four columns: chromosomes, positions, reference
 allele count, alternative allele count.
}
\description{
Extract read counts from VCF file of a single sample.
}
\note{
The VCF file should only contain one sample. If more samples present in
 the VCF, it only returns coverage for of the first sample.
}
\examples{
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390 = extractCoverageFromVcf(vcfFile)

}
