% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ships_methods.R
\name{ais.to.DeponsShips}
\alias{ais.to.DeponsShips}
\title{Convert ship tracks to DeponsShips object}
\usage{
ais.to.DeponsShips(data, landsc, title = "NA", ...)
}
\arguments{
\item{data}{data.frame with ship positions and the times at which the
positions were recorded. Must contain the columns 'id', 'time' (of the form
"%Y-%m-%d %H:%M:%S", character, see \code{\link{as.POSIXct}}), 'type' (ship
type, character), 'length' (ship length, meters), 'x', and 'y' (position,
meters/UTM).}

\item{landsc}{A \code{DeponsRaster} object corresponding to the
landscape that the ships move in. It is assumed that the spatial projection
of the ship positions corresponds to that of the DeponsRaster object}

\item{title}{Title of the output object}

\item{...}{Optional parameters, including 'startday' and 'endday'
("%Y-%m-%d %H:%M:%S", character) for defining the first and last date to use
from 'data'. If startday = endday the output object will contain up to
49 positions from the selected date for each vessel track.}
}
\value{
Returns a \code{DeponsShips} object containing one or more ships
assigned to each of the routes in the object. All ships on a particular
route move at the same speed along the route. The routes are
defined by x and y coordinates based on the same coordinate reference
system as the landscape they are located in. The speed that ships use after
reaching a particular position (a particular 'virtual buoy') is calculated
from the distance to the following position, and the time it takes reaching
that position. If speed is included in the input AIS data, this is NOT used.
The routes include one position per half-hour time step, corresponding to
the default time step used in the DEPONS model. If input data does not
include one position per half hour, new positions are generated using linear
interpolation. If the input data contains many positions in a particular
half-hour interval, only the positions closest to the half-hour interval are
used. The routes contain information about the number of half-hour
intervals were ships 'pause' at a particular location, e.g. in a
port. These are calculated based on the input AIS data.
}
\description{
Convert Automatic Identification System (AIS) data for ships to
ship track objects. This is done by cropping one or more ship tracks to the
extent of a landscape and converting the data to a \code{DeponsShips-class}
object. If the AIS data does not include ship positions recorded in half-hour
steps, the tracks are interpolated to make objects suitable for use in DEPONS.
}
\examples{
data(aisdata)
plot(aisdata$x, aisdata$y, type="n", asp=1)
ids <- sort(unique(aisdata$id))
my.colors <- heat.colors(length(ids))
for (i in 1:length(ids)) {
  id <- ids[i]
  points(aisdata$x[aisdata$id==id], aisdata$y[aisdata$id==id],
     cex=0.6, col=my.colors[i])
}
data(bathymetry)
plot(bathymetry, add=TRUE)
depons.ais <- ais.to.DeponsShips(aisdata, bathymetry)
the.routes <- routes(depons.ais)
for (i in 1:length(ids)) {
points(the.routes[[i]]$x, the.routes[[i]]$y,
        cex=0.6, pch=16, col=my.colors[i])
}
depons.ais <- ais.to.DeponsShips(aisdata, bathymetry,
   startday="2015-12-20", endday="2015-12-20")
routes(depons.ais)
aisdata2 <- aisdata
aisdata2$time <- as.character(as.POSIXct(aisdata$time)+300)
depons.ais2 <- ais.to.DeponsShips(aisdata2, bathymetry,
                               startday="2015-12-20", endday="2015-12-21")
routes(depons.ais2)
}
\seealso{
\code{\link{aisdata}} for an example of data that can be used as
input to ais.to.DeponsShips and \code{\link{interpolate.ais.data}} interpolation
of tracks. See \code{\link[DEPONS2R]{write.DeponsShips}} for conversion of
\code{DeponsShips} objects to json-files to be used in DEPONS. Use
\code{\link{routes}}, \code{\link{ships}}, and \code{\link{title}} for
inspection/modification of the ship tracks.
}
