% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEET_feature_extract.R
\name{DEET_feature_extract}
\alias{DEET_feature_extract}
\title{DEET_feature_extract}
\usage{
DEET_feature_extract(mat, response, datatype, detection_cutoff = 0.7)
}
\arguments{
\item{mat}{A gene-by-study matrix populated by the coefficients of that study.
By default, the coefficient is the log2Fold-change of genes as long as they are
differentially expressed (cutoff = padj < 0.05).}

\item{response}{A vector (binomial, categorical, or continuous) that is used to
associated the DEGs within the studies.}

\item{datatype}{indication of whether the response variable is binomial,
categorical, or continuous.}

\item{detection_cutoff}{Proportion of studies where the gene is detected (not
as DE but detected at all, designated with a FC != 0). Default value 0.7.}
}
\value{
Named list given the elastic net coefficients and the eleastic net
regression between the response variable and the DEGs within DEET.
It also outputs the correlation, ANOVA, and wilcoxon test of every gene
against the response variable based on if it's continuous, categorical, or
binomial in nature.

\itemize{
  \item elastic_net_coefficients - Association that a gene has with the
  response variable based on the elastic net regression.
  \item elastic_net - Output of the elastic net regression
  \item - basic_features gives the output of the
  correlation, ANOVA, and wilcoxon test of every gene against the
  response variable.
}
}
\description{
Identify which genes are associated with pieces of
metadata that a researcher queries.
}
\examples{

data(DEET_feature_extract_example_matrix)
data(DEET_feature_extract_example_response)
single1 <- DEET_feature_extract(DEET_feature_extract_example_matrix,
DEET_feature_extract_example_response,"categorical")

}
\references{
Engebretsen, S., & Bohlin, J. (2019). Statistical predictions with glmnet.
Clinical epigenetics, 11(1), 1-3.
}
\author{
Dustin Sokolowski, Jedid Ahn
}
