% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCS_MainFunctions.R
\name{surface.dcs}
\alias{surface.dcs}
\title{3D Surface Plot of "dcs"-object or numeric matrix}
\usage{
surface.dcs(Y, plot_choice = "choice", ...)
}
\arguments{
\item{Y}{an object of class \code{"dcs"} or a numeric matrix that contains the
values to be plotted.}

\item{plot_choice}{override the prompt to specify a plot, can be 
\code{c(1, 2, 3)}.}

\item{...}{optional arguments passed to the plot function.}
}
\value{
\code{dcs.3d} returns an object of class "plotly" and "htmlwidget".
}
\description{
3D Surface Plot of "dcs"-object or numeric matrix
}
\section{Details}{

\code{surface.dcs} uses the plotly device to plot the 3D surface of the given
\code{"dcs"}-object or matrix. If a "dcs"-object is passed to the function, 
 it can be chosen between plots of the original data (1), smoothed surface 
 (2) and residuals (3).
}

\examples{
# See vignette("DCSmooth") for examples and explanation

smth =  dcs(y.norm1 + rnorm(101^2))
surface.dcs(smth, plot_choice = 2)

}
\seealso{
\code{\link{plot.dcs}}
}
