% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_b2.R
\name{calcb2}
\alias{calcb2}
\title{calc_b2.R}
\usage{
calcb2(lower = TRUE, upper = FALSE, muVec, sigMat, bounds)
}
\arguments{
\item{lower}{Boolean, whether to calculate lower bound.}

\item{upper}{Boolean, whether to calculate upper bound.}

\item{muVec}{Mean vector of test statistics under the alternative (assuming it's MVN).}

\item{sigMat}{Covariance matrix of test statistics under the alternative (assuming it's MVN).}

\item{bounds}{A J*1 vector of bounds on the magnitudes of the test statistics, where
the first element is the bound for |Z|_(1) and the last element is the bound for |Z|_(J).}
}
\value{
A list with the elements:
\item{allProbsLower}{J*1 vector of all components summed to calculate lower bound.}
\item{lowerProb}{Lower bound.}
\item{allProbsUpper}{J*1 vector of all components summed to calculate upper bound.}
\item{upperProb}{Upper bound.}
}
\description{
Calculate lower bound or upper bound on power when considering only the two largest
test statistic in magnitude, i.e. only |Z|_(J) and |Z|_(J-1).
}
\examples{
myCov <- matrix(data=0.3, nrow=5, ncol=5)
diag(myCov) <- 1
myBounds <- set_GBJ_bounds(alpha = 0.01, J=5, sig_vec = myCov[lower.tri(myCov)])
calcb2(muVec = c(1, 0, 0, 0, 0), sigMat = myCov, bounds=myBounds)

}
