% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-create.R
\docType{methods}
\name{sqlCreateTable}
\alias{sqlCreateTable}
\alias{sqlCreateTable,DBIConnection-method}
\title{Create a simple table.}
\usage{
sqlCreateTable(con, table, fields, row.names = NA, temporary = FALSE, ...)

\S4method{sqlCreateTable}{DBIConnection}(con, table, fields, row.names = NA,
  temporary = FALSE, ...)
}
\arguments{
\item{con}{A database connection.}

\item{table}{Name of the table. Escaped with
\code{\link[DBI]{dbQuoteIdentifier}}.}

\item{fields}{Either a character vector or a data frame.

  A named character vector: Names are column names, values are types.
  Names are escaped with \code{\link[DBI]{dbQuoteIdentifier}}.
  Field types are unescaped.

  A data frame: field types are generated using
  \code{\link[DBI]{dbDataType}}.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

  If \code{TRUE}, always translate row names to a column called "row_names".
  If \code{FALSE}, never translate row names. If \code{NA}, translate
  rownames only if they're a character vector.

  A string is equivalent to \code{TRUE}, but allows you to override the
  default name.

  For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{temporary}{If \code{TRUE}, will generate a temporary table statement.}

\item{...}{Other arguments used by individual methods.}
}
\description{
Exposes interface to simple \code{CREATE TABLE} commands. The default
method is ANSI SQL 99 compliant.
}
\section{DBI-backends}{

If you implement one method (i.e. for strings or data frames), you need
to implement both, otherwise the S4 dispatch rules will be ambiguous
and will generate an error on every call.
}
\examples{
sqlCreateTable(ANSI(), "my-table", c(a = "integer", b = "text"))
sqlCreateTable(ANSI(), "my-table", iris)

# By default, character row names are converted to a row_names colum
sqlCreateTable(ANSI(), "mtcars", mtcars[, 1:5])
sqlCreateTable(ANSI(), "mtcars", mtcars[, 1:5], row.names = FALSE)
}

