% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbGetQuery}
\alias{dbGetQuery}
\alias{dbGetQuery,DBIConnection,character-method}
\title{Send query, retrieve results and then clear result set.}
\usage{
dbGetQuery(conn, statement, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\description{
\code{dbGetQuery} comes with a default implementation that calls
\code{\link{dbSendQuery}}, then \code{\link{dbFetch}}, ensuring that
the result is always free-d by \code{\link{dbClearResult}}.
}
\section{Implementation notes}{

Subclasses should override this method only if they provide some sort of
performance optimisation.
}
\examples{
if (require("RSQLite")) {
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
dbGetQuery(con, "SELECT * FROM mtcars")

dbBegin(con)
dbGetQuery(con, "DELETE FROM mtcars WHERE cyl == 4")
dbRollback(con)

dbDisconnect(con)
}
}
\seealso{
Other connection methods: \code{\link{dbDisconnect}},
  \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbListFields}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}
}

