% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_surrogate.R
\name{predict_surrogate}
\alias{predict_surrogate}
\alias{predict_parts_break_down}
\alias{predict_parts}
\alias{predict_parts_ibreak_down}
\alias{predict_parts_shap}
\alias{predict_surrogate_local_model}
\alias{predict_model.dalex_explainer}
\alias{model_type.dalex_explainer}
\alias{predict_surrogate_lime}
\alias{plot.predict_surrogate_lime}
\alias{predict_surrogate_iml}
\title{Instance Level Surrogate Models}
\usage{
predict_surrogate(explainer, new_observation, ..., type = "localModel")

predict_surrogate_local_model(
  explainer,
  new_observation,
  size = 1000,
  seed = 1313,
  ...
)

predict_model.dalex_explainer(x, newdata, ...)

model_type.dalex_explainer(x, ...)

predict_surrogate_lime(
  explainer,
  new_observation,
  n_features = 4,
  n_permutations = 1000,
  labels = unique(explainer$y)[1],
  ...
)

\method{plot}{predict_surrogate_lime}(x, ...)

predict_surrogate_iml(explainer, new_observation, k = 4, ...)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the 'explain' function}

\item{new_observation}{a new observation for which predictions need to be explained}

\item{...}{other parameters that will be passed to}

\item{type}{which implementation of thee LIME method should be used. Either \code{localModel} (default), \code{lime} or \code{iml}.}

\item{size}{will be passed to the localModel implementation, by default 1000}

\item{seed}{seed for random number generator, by default 1313}

\item{x}{an object to be plotted}

\item{newdata}{alias for new_observation}

\item{n_features}{will be passed to the lime implementation, by default 4}

\item{n_permutations}{will be passed to the lime implementation, by default 1000}

\item{labels}{will be passed to the lime implementation, by default first value in the y vector}

\item{k}{will be passed to the iml implementation, by default 4}
}
\value{
Depending on the \code{type} there are different classess of the resulting object.
}
\description{
Interface to different implementations of the LIME method.
Find information how the LIME method works here: \url{https://pbiecek.github.io/ema/LIME.html}.
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema/}
}
