% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{initialize,D2C.descriptor-method}
\alias{initialize,D2C.descriptor-method}
\title{creation of a D2C.descriptor}
\usage{
\S4method{initialize}{D2C.descriptor}(.Object, lin = TRUE, acc = TRUE,
  struct = TRUE, pq = c(0.1, 0.25, 0.5, 0.75, 0.9), bivariate = FALSE,
  ns = 4)
}
\arguments{
\item{.Object}{: the D2C.descriptor object}

\item{lin}{:    TRUE OR FALSE: if TRUE it uses a linear model to assess a dependency, otherwise a local learning algorithm}

\item{acc}{: TRUE OR FALSE: if TRUE it uses the accuracy of the regression as a descriptor}

\item{struct}{: TRUE or FALSE to use the ranking in the markov blanket as a descriptor}

\item{pq}{:a vector of quantiles used to compute the descriptors}

\item{bivariate}{:TRUE OR FALSE: if TRUE it includes also the descriptors of the bivariate dependence}

\item{ns}{: size of the Markov Blanket returned by the mIMR algorithm}
}
\description{
creation of a D2C.descriptor
}
\examples{
require(RBGL)
require(gRbase)
require(foreach)
descr.example<-new("D2C.descriptor",bivariate=FALSE,ns=3,acc=TRUE)
trainDAG<-new("simulatedDAG",NDAG=2, N=50,noNodes=10,
             functionType = "linear", seed=0,sdn=0.5)
}
\references{
Gianluca Bontempi, Maxime Flauder (2014) From dependency to causality: a machine learning approach. Under submission
}

