% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_get_cluster.R
\name{cc_get_cluster}
\alias{cc_get_cluster}
\alias{cc_get_cluster.default}
\alias{cc_get_cluster.crossclustering}
\title{Provides the vector of clusters' ID to which each element belong to.}
\usage{
cc_get_cluster(x, n_elem)

\method{cc_get_cluster}{default}(x, n_elem)

\method{cc_get_cluster}{crossclustering}(x, n_elem)
}
\arguments{
\item{x}{list of clustered elements or a \code{crossclustering} object}

\item{n_elem}{total number of elements clustered (ignored if x
is of class \code{crossclustering})}
}
\value{
An integer vector of clusters to which the elements belong (`1`
        for the outliers, ID + 1 for the others).
}
\description{
Provides the vector of clusters' ID to which each element belong to.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for \code{\link{cc_get_cluster}}.

\item \code{crossclustering}: automatically extract inputs from a \code{crossclustering} object
}}

\examples{
library(CrossClustering)

data(toy)

### toy is transposed as we want to cluster samples (columns of the
### original matrix)
toy_dist <- t(toy) \%>\% dist(method = "euclidean")

### Run CrossClustering
toyres <- cc_crossclustering(toy_dist,
  k_w_min = 2,
  k_w_max = 5,
  k2_max  = 6,
  out     = TRUE
)

### cc_get_cluster
cc_get_cluster(toyres[], 7)


### cc_get_cluster directly from a crossclustering object
cc_get_cluster(toyres)
}
\references{
Tellaroli P, Bazzi M., Donato M., Brazzale A. R., Draghici S. (2016).
Cross-Clustering: A Partial Clustering Algorithm with Automatic
Estimation of the Number of Clusters. PLoS ONE 11(3):   e0152333.
doi:10.1371/journal.pone.0152333
}
\author{
Paola Tellaroli, <paola [dot] tellaroli [at] unipd [dot] it>;;
Marco Bazzi, <bazzi [at] stat [dot] unipd [dot] it>;
Michele Donato, <mdonato [at] stanford [dot] edu>.
}
