% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convCount_probs.R
\name{dCount_conv_user}
\alias{dCount_conv_user}
\title{Compute count probabilities using convolution (user)}
\usage{
dCount_conv_user(x, distPars, extrapolPars, survR, method = c("dePril",
  "direct", "naive"), nsteps = 100, time = 1, extrap = TRUE,
  log = FALSE)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{distPars}{\code{Rcpp::List} with distribution specific slots. See details.}

\item{extrapolPars}{ma::vec of length 2. The extrapolation values.}

\item{survR}{Rcpp::Function user passed survival function; should have the
signature \code{function(t, distPars)} where \code{t} is a real number (>0)
where the survival function is evaluated and \code{distPars} is a list of
distribution parameters. It should return a double value.}

\item{method}{TODO}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.}

\item{log}{logical if \code{TRUE} the log-probability will be returned.}
}
\value{
vector of probabilities P(x(i)) for i = 1, ..., n where n is
\code{length} of \code{x}.
}
\description{
Compute count probabilities using one of the convolution methods for user
passed survival functions.
}
\examples{
## see examples for dCount_conv_bi
}

