% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAP.continuous.R
\name{MAP.continuous}
\alias{MAP.continuous}
\title{Estimation of latent variables in the continuous case}
\usage{
MAP.continuous(u, family, rot, thC0k, dfC = NULL, nq = 35)
}
\arguments{
\item{u}{vector of values in (0,1)}

\item{family}{copula family: "gaussian" , "t" , "clayton" ,  "joe", "frank" , "fgm", gumbel", "plackett", "galambos", "huesler-reiss"}

\item{rot}{rotation: 0 (default), 90, 180 (survival), or 270.}

\item{thC0k}{vector of copula parameters}

\item{dfC}{degrees of freedome for the Student copula (default is NULL)}

\item{nq}{number of nodes and weighted for Gaussian quadrature of the product of conditional copulas; default is 31.}
}
\value{
\item{condmed}{Conditional a posteriori median.}
}
\description{
This function computes the estimation of a latent variables for each cluster using the conditional a posteriori median.
}
\examples{
u = c(0.5228155, 0.3064417, 0.2789849, 0.5176489, 0.3587144)
thC0k=rep(17.54873,5)
MAP.continuous(u,"clayton",rot=90,thC0k,nq=35)
}
\references{
Krupskii, Nasri & Remillard (2023). On factor copula-based mixed regression models
}
\author{
Pavel Krupskii, Bouchra R. Nasri and Bruno N. Remillard
}
