% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidDictator}
\alias{stopOnInvalidDictator}
\title{Parameter Function stopOnInvalidDictator}
\usage{
stopOnInvalidDictator(paramCheckResult, dictator, n = NULL)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{dictator}{Number of the dictator}

\item{n}{represents the number of players}
}
\description{
stopOnInvalidDictator checks if dictator
 is specified correctly in a dictator game.
 Validation result gets stored to object paramCheckResult 
 in case an error occured and causes calculation to stop.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1090 \tab 'dictator' does not contain only one single element \cr
1091 \tab Representation of 'dictator' is not 'numeric' \cr
1092 \tab 'dictator' is not element of grand coalition \cr
1093 \tab 'dictator' is 'NULL' }
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validDictator = 3
stopOnInvalidDictator(paramCheckResult,dictator=validDictator,n=3)

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
\concept{ParameterChecks_CoopGame}
