% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatelyConcept.R
\name{propensityToDisrupt}
\alias{propensityToDisrupt}
\title{Compute propensity to disrupt}
\usage{
propensityToDisrupt(v, x, S)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{x}{numeric vector containing allocations for each player}

\item{S}{numeric vector with coalition of players}
}
\value{
propensity to disrupt as numerical value
}
\description{
propensityToDisrupt for calculating the propensity of disrupt for game vector v, an allocation x and a specified coalition S
}
\examples{
library(CoopGame)
v=c(0,0,0,4,0,3,6)
x=c(2,3,1)
propensityToDisrupt(v,x,S=c(1))

}
\references{
Littlechild S.C. and Vaidya K.G. (1976) "The propensity to disrupt and the disruption nucleolus of a characteristic function game", Int. Journal of Game Theory 5(2), pp. 151--161

Staudacher J. and Anwander J. (2019) "Conditions for the uniqueness of the Gately point for cooperative games", arXiv preprint, arXiv:1901.01485, 10 pages.
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
