% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MajoritySingleVetoGame.R
\name{majoritySingleVetoGameValue}
\alias{majoritySingleVetoGameValue}
\title{Compute value of a coalition for a weighted majority game with a single veto player}
\usage{
majoritySingleVetoGameValue(S, vetoPlayer)
}
\arguments{
\item{S}{numeric vector with coalition of players}

\item{vetoPlayer}{represents the veto player}
}
\value{
\code{1} if vetoPlayer is included in \code{S} and 
\code{S} is not a singleton coalition, \code{0} otherwise
}
\description{
\strong{Coalition value for a weighted majority game with a single veto player:} \cr
For further information see \link{majoritySingleVetoGame}
}
\examples{
library(CoopGame)
majoritySingleVetoGameValue(S=c(1,2), vetoPlayer=1)

}
\references{
Jackson M.O. (2008)  \emph{Social and Economic Networks}, Princeton University Press, p. 415
}
\author{
Michael Maerz

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
