% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GloveGame.R
\name{gloveGame}
\alias{gloveGame}
\title{Construct a glove game}
\usage{
gloveGame(n, L, R)
}
\arguments{
\item{n}{represents the number of players}

\item{L}{numeric vector of players owning one left-hand glove each}

\item{R}{numeric vector of players owning one right-hand glove each}
}
\value{
A list with four elements 
representing the glove game (n, L, R, Game vector v)
}
\description{
\strong{Create a list containing 
all information about a specified glove game:} \cr
We have a set of players \code{L} with left-hand gloves and 
a set of players \code{R} with right-hand gloves.
The worth of a coalition \code{S} equals the number of 
pairs of gloves the members of \code{S} can make. 
Note that the sets \code{L} and \code{R} have to be disjoint.
}
\section{Related Functions}{
 
\link{gloveGameValue}, \link{gloveGameVector}
}

\examples{
library(CoopGame)
gloveGame(n=3,L=c(1,2), R=c(3))

\donttest{
#Example with four players: 
#players 1, 2 and 4 hold a left-hand glove each, 
#player 3 holds a right-hand glove. 
library(CoopGame)
(vv<-gloveGame(n=4,L=c(1,2,4), R=c(3)))
#$n
#[1] 3

#$L
#[1] 1 2 4
#
#$R
#[1] 3
#
#$v
#[1] 0 0 0 0 0 1 0 1 0 1 1 0 1 1 1
}

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 155--156
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
