% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExcessCoefficients.R
\name{getExcessCoefficients}
\alias{getExcessCoefficients}
\title{Compute excess coefficients}
\usage{
getExcessCoefficients(v, x)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{x}{numeric vector containing allocations for each player}
}
\value{
numeric vector containing the excess coefficients for every coalition
}
\description{
getExcessCoefficients computes the excess coefficients for a 
specified TU game and an allocation x
}
\examples{
library(CoopGame)
getExcessCoefficients(c(0,0,0,60,48,30,72), c(24,24,24))

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 58

Driessen T. (1998) \emph{Cooperative Games, Solutions and Applications}, Springer, p. 12
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
