% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicGoodIndexConcept.R
\name{drawPublicGoodIndex}
\alias{drawPublicGoodIndex}
\title{Draw Public Good index for 3 or 4 players}
\usage{
drawPublicGoodIndex(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Public Good Index")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawPublicGoodIndex draws the Public Good Index of a simple game for 3 or 4 players.
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
drawPublicGoodIndex(v)
}
\references{
Holler M.J. and Packel E.W. (1983) "Power, luck and the right index", Zeitschrift fuer Nationaloekonomie 43(1), pp. 21--29

Holler M. (2011) "Public Goods index", Encyclopedia of Power, SAGE Publications, pp. 541--542
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
