% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DECORcore.R
\name{DECORcore}
\alias{DECORcore}
\title{Differential Evolution algorithm for Median Ranking}
\usage{
DECORcore(cij, NJ, NP = 15, L = 50, FF = 0.4, CR = 0.9, FULL = FALSE)
}
\arguments{
\item{cij}{combined input matrix}

\item{NJ}{the number of judjes}

\item{NP}{The number of population individuals}

\item{L}{Generations limit: maximum number of consecutive generations without improvement}

\item{FF}{The scaling rate for mutation. Must be in [0,1]}

\item{CR}{The crossover range. Must be in [0,1]}

\item{FULL}{Default FULL=FALSE. If FULL=TRUE, the searching is limited to the space of full rankings. In this case, the data matrix must contain full rankings.}
}
\value{
a "list" containing the following components:
\tabular{lll}{
ConsR \tab  \tab the Consensus Ranking\cr
Tau \tab       \tab averaged TauX rank correlation coefficient\cr
besti\tab   \tab matrix of best individuals for every generation\cr
bestc\tab  \tab vector of best individuals' cost for every gen\cr
bests\tab   \tab  \cr vector of best individuals
avgTau\tab   \tab  \cr maximum average tauX
Eltime\tab  \tab Elapsed time in seconds}
}
\description{
Core function of the DECOR algorithm
}
\references{
D'Ambrosio, A., Mazzeo, G., Iorio, C., and Siciliano, R. (2017). A differential evolution algorithm for finding the median ranking under the Kemeny axiomatic approach. Computers and Operations Research, vol. 82, pp. 126-138.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it} and Giulio Mazzeo \email{giuliomazzeo@gmail.com}
}
