% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_Hanwell.R
\name{tidy_Hanwell}
\alias{tidy_Hanwell}
\title{Tidy Hanwell EMS Data (Min-Max report)}
\usage{
tidy_Hanwell(EMS_MinMax_datapath)
}
\arguments{
\item{EMS_MinMax_datapath}{EMS_MinMax_datapath Character string specifying the
file path to the Hanwell EMS data file.}
}
\value{
A tibble containing the tidied Hanwell EMS data with the following columns:

\itemize{
  \item Date Time POSIXct datetime of the measurement
  \item Sensor Character string identifying the sensor
  \item TempMin Numeric minimum temperature (°C)
  \item TempMax Numeric maximum temperature (°C)
  \item Temp Numeric average temperature (°C)
  \item RHMin Numeric minimum relative humidity (%)
  \item RHMax Numeric maximum relative humidity (%)
  \item RH Numeric average relative humidity (%)
  \item Date Date of the measurement (duplicate of Date Time)
}
}
\description{
This function reads and processes Hanwell Environmental Monitoring System (EMS) data,
transforming it into a tidy format suitable for analysis.
}
\examples{

\donttest{
# Example usage: hanwell_data <- tidy_Hanwell("path/to/your/EMS_MinMax_data.csv")
}



}
