% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraintsReg.R
\name{cglasso}
\alias{cglasso}
\title{Fit a linearly constrained linear regression model with group lasso regularization.}
\usage{
cglasso(y, Z, Zc = NULL, k, W = rep(1, times = p), intercept = TRUE,
        A =  kronecker(matrix(1, ncol = p), diag(k)), b = rep(0, times = k),
        u = 1, mu_ratio = 1.01,
        lam = NULL, nlam = 100,lambda.factor = ifelse(n < p1, 0.05, 0.001),
        dfmax = p, pfmax = min(dfmax * 1.5, p), tol = 1e-8,
        outer_maxiter = 1e+6, outer_eps = 1e-8,
        inner_maxiter = 1e+4, inner_eps = 1e-8)
}
\arguments{
\item{y}{respones vector with length \eqn{n}.}

\item{Z}{design matrix of dimension \eqn{n \times p1}{n*p1}.}

\item{Zc}{design matrix for unpenalized variables. Default value is NULL.}

\item{k}{the group size in \eqn{Z}. The number of groups is \eqn{p = p1 / k }.}

\item{W}{a vector in length p (the total number of groups), or a matrix with dimension \code{p1*p1}.
Default value is rep(1, times = p).
\itemize{
\item a vector of penalization weights for the groups of coefficients. A zero weight implies no shrinkage.
\item a diagonal matrix with positive diagonal elements.
}}

\item{intercept}{Boolean, specifying whether to include an intercept.
Default is TRUE.}

\item{A, b}{linear equalities of the form \eqn{A\beta_{p1} = b}, where \eqn{b} is a vector with length \eqn{k}, and \eqn{A} is
a \eqn{k \times p1}{k*p1} matrix.
Default values: \eqn{b} is a vector of 0's and
\cr
\code{A = kronecker(}\code{matrix(1, ncol = p), diag(k))}.}

\item{u}{the inital value of the penalty parameter of the augmented Lagrange method adopted in the outer loop. Default value is 1.}

\item{mu_ratio}{the increasing ratio of the penalty parameter \code{u}. Default value is 1.01.
Inital values for scaled Lagrange multipliers are set as 0's.
If \code{mu_ratio} < 1, the program automatically set
the initial penalty parameter \code{u} as 0
and \code{outer_maxiter} as 1, indicating
that there is no linear constraint.}

\item{lam}{a user supplied lambda sequence.
If \code{lam} is provided as a scaler and \code{nlam}\eqn{>1}, \code{lam} sequence is created starting from
\code{lam}. To run a single value of \code{lam}, set \code{nlam}\eqn{=1}.
The program will sort user-defined \code{lambda} sequence in decreasing order.}

\item{nlam}{the length of the \code{lam} sequence. Default is 100. No effect if \code{lam} is
provided.}

\item{lambda.factor}{the factor for getting the minimal lambda in \code{lam} sequence,
where \code{min(lam)} = \code{lambda.factor} * \code{max(lam)}.
\code{max(lam)} is the smallest value of \code{lam} for which all penalized group are 0's.
If \eqn{n >= p1}, the default is \code{0.001}. If \eqn{n < p1}, the default is \code{0.05}.}

\item{dfmax}{limit the maximum number of groups in the model. Useful for handling very large \eqn{p}, if a partial path is desired.
Default is \eqn{p}.}

\item{pfmax}{limit the maximum number of groups ever to be nonzero. For example once a group enters the model along the path,
no matter how many times it re-enters the model through the path, it will be counted only once.
Default is \code{min(dfmax*1.5, p)}.}

\item{tol}{tolerance for coefficient to be considered as non-zero.
Once the convergence criterion is satisfied, for each element \eqn{\beta_j} in coefficient vector
\eqn{\beta}, \eqn{\beta_j = 0} if \eqn{\beta_j < tol}.}

\item{outer_maxiter, outer_eps}{\code{outer_maxiter} is the maximun number of loops allowed for the augmented Lagrange method;
and \code{outer_eps} is the corresponding convergence tolerance.}

\item{inner_maxiter, inner_eps}{\code{inner_maxiter} is the maximum number of loops allowed for blockwise-GMD;
and \code{inner_eps} is the corresponding convergence tolerance.}
}
\value{
A list of
\item{beta}{a matrix of coefficients.}
\item{lam}{the sequence of lambda values.}
\item{df}{a vector, the number of nonzero groups in estimated coefficients for \code{Z} at each value of lambda.}
\item{npass}{total number of iteration.}
\item{error}{a vector of error flag.}
}
\description{
Fit a linearly constrained regression model with group lasso regularization.
}
