\name{UDesigns_I}
\alias{UDesigns_I}
\title{
Orthogonal Uniform Designs with two factors
}
\description{
For v = pq (p>2,q>=2 and v>=6) these uniform designs are generated. This function provides designs based on two types. It also provides number of factors, number of levels, number of runs along with maximum absolute correlation value and discrete discrepancy measure with its lower bound value.
}
\usage{
UDesigns_I(p, q, type)
}
\arguments{
  \item{p}{ any integer >2
}
  \item{q}{ any integer >=2
}
  \item{type}{ 1 or 2
}
}
\details{
Type 1 or type 2 both can be exist for a same parameter range. For type 1 it will require more runs than designs generated by type 2. But type 1 provides designs which are having more spread than type 2 series designs.
}
\value{
Returns a uniform designs along with number of factors, levels, runs, maximum absolute value and discrete discrepancy measure with its lower bound value.
}
\author{
Ashutosh Dalal,
Cini Varghese,
Rajender Parsad and
Mohd Harun
}
\examples{
library(CompExpDes)
UDesigns_I(4,3,1)
}
\references{
Fang, K.T. (1980). The uniform design: application of number-theoretic methods in experimental design. Acta Math Appl Sin, 3, 363-372.
}
\keyword{Uniform designs}
\keyword{UD}
\keyword{Discrete Discrepancy}
\keyword{Orthogonal uniform designs}
\keyword{Two factor orthogonal uniform designs}
\keyword{LHD}
\keyword{CompExpDes}
\keyword{Latin Hypercube Designs}
\keyword{Computer Experiments}
\keyword{Space-Filling Designs}