/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import javax.swing.JComponent;
import javax.swing.JPanel;
import net.infonode.gui.layout.StackableLayout;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;

public class TabContentPanel
extends JPanel {
    private TabbedPanel tabbedPanel;
    private StackableLayout layout = new StackableLayout(this);
    private TabListener listener = new TabAdapter(){

        public void tabSelected(TabStateChangedEvent tabStateChangedEvent) {
            TabContentPanel.this.layout.showComponent(tabStateChangedEvent.getTab() == null ? null : tabStateChangedEvent.getTab().getContentComponent());
        }

        public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
            if (tabRemovedEvent.getTab().getContentComponent() != null) {
                TabContentPanel.this.remove(tabRemovedEvent.getTab().getContentComponent());
            }
        }

        public void tabAdded(TabEvent tabEvent) {
            if (tabEvent.getTab().getContentComponent() != null) {
                TabContentPanel.this.add(tabEvent.getTab().getContentComponent());
            }
        }
    };

    public TabContentPanel() {
        this.setLayout(this.layout);
        this.setOpaque(false);
        this.layout.setAutoShowFirstComponent(false);
    }

    public TabContentPanel(TabbedPanel tabbedPanel) {
        this();
        this.setTabbedPanel(tabbedPanel);
    }

    public TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    public void setTabbedPanel(TabbedPanel tabbedPanel) {
        if (this.tabbedPanel != tabbedPanel) {
            if (this.tabbedPanel != null) {
                this.tabbedPanel.removeTabListener(this.listener);
                this.removeAll();
            }
            this.tabbedPanel = tabbedPanel;
            if (this.tabbedPanel != null) {
                tabbedPanel.addTabListener(this.listener);
                for (int i = 0; i < tabbedPanel.getTabCount(); ++i) {
                    JComponent jComponent = tabbedPanel.getTabAt(i).getContentComponent();
                    if (jComponent == null) continue;
                    this.add(tabbedPanel.getTabAt(i).getContentComponent());
                }
            }
        }
    }
}

