/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.util.ViewFactory;
import net.infonode.docking.util.ViewFactoryManager;

public abstract class AbstractViewMap
implements ViewFactoryManager,
ViewSerializer {
    private HashMap viewMap = new HashMap();
    private ArrayList views = new ArrayList(20);

    protected abstract void writeViewId(Object var1, ObjectOutputStream var2) throws IOException;

    protected abstract Object readViewId(ObjectInputStream var1) throws IOException;

    public int getViewCount() {
        return this.viewMap.size();
    }

    public View getViewAtIndex(int n) {
        return (View)this.views.get(n);
    }

    public ViewFactory[] getViewFactories() {
        ArrayList<1> arrayList = new ArrayList<1>();
        for (int i = 0; i < this.views.size(); ++i) {
            final View view = (View)this.views.get(i);
            if (view.getRootWindow() != null) continue;
            arrayList.add(new ViewFactory(){

                public Icon getIcon() {
                    return view.getIcon();
                }

                public String getTitle() {
                    return view.getTitle();
                }

                public View createView() {
                    return view;
                }
            });
        }
        return arrayList.toArray(new ViewFactory[arrayList.size()]);
    }

    public boolean contains(View view) {
        return this.views.contains(view);
    }

    public void writeView(View view, ObjectOutputStream objectOutputStream) throws IOException {
        Iterator iterator = this.viewMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != view) continue;
            this.writeViewId(entry.getKey(), objectOutputStream);
            return;
        }
        throw new IOException("Serialization of unknown view!");
    }

    public View readView(ObjectInputStream objectInputStream) throws IOException {
        return (View)this.viewMap.get(this.readViewId(objectInputStream));
    }

    protected void addView(Object object, View view) {
        View view2 = this.viewMap.put(object, view);
        if (view2 != null) {
            this.views.remove(view2);
        }
        this.views.add(view);
    }

    protected void removeView(Object object) {
        Object v = this.viewMap.remove(object);
        if (v != null) {
            this.views.remove(v);
        }
    }

    protected View getView(Object object) {
        return (View)this.viewMap.get(object);
    }
}

