/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.internalutil;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JPopupMenu;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.properties.WindowTabButtonProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewMap;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.util.IntList;
import net.infonode.util.Printer;

public class InternalDockingUtil {
    public static final int DEFAULT_BUTTON_ICON_SIZE = 10;

    private InternalDockingUtil() {
    }

    public static void getViews(DockingWindow dockingWindow, ArrayList arrayList) {
        if (dockingWindow == null) {
            return;
        }
        if (dockingWindow instanceof View) {
            arrayList.add(dockingWindow);
        } else {
            for (int i = 0; i < dockingWindow.getChildWindowCount(); ++i) {
                InternalDockingUtil.getViews(dockingWindow.getChildWindow(i), arrayList);
            }
        }
    }

    public static IntList getWindowPath(DockingWindow dockingWindow) {
        return InternalDockingUtil.getWindowPath(dockingWindow, IntList.EMPTY_LIST);
    }

    public static DockingWindow getWindow(DockingWindow dockingWindow, IntList intList) {
        return intList.isEmpty() ? dockingWindow : (intList.getValue() >= dockingWindow.getChildWindowCount() ? null : InternalDockingUtil.getWindow(dockingWindow.getChildWindow(intList.getValue()), intList.getNext()));
    }

    private static IntList getWindowPath(DockingWindow dockingWindow, IntList intList) {
        DockingWindow dockingWindow2 = dockingWindow.getWindowParent();
        return dockingWindow2 == null ? intList : InternalDockingUtil.getWindowPath(dockingWindow2, new IntList(dockingWindow2.getChildWindowIndex(dockingWindow), intList));
    }

    public static void addDebugMenuItems(JPopupMenu jPopupMenu, final DockingWindow dockingWindow) {
        jPopupMenu.add("Dump Tree").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InternalDockingUtil.dump(dockingWindow, new Printer());
            }
        });
    }

    public static void dump(DockingWindow dockingWindow, Printer printer) {
        DockingWindow dockingWindow2 = dockingWindow.getWindowParent();
        String string = dockingWindow.getClass().getName();
        printer.println(string.substring(string.lastIndexOf(46) + 1) + ", " + System.identityHashCode(dockingWindow) + " (" + (dockingWindow2 == null ? "null" : String.valueOf(System.identityHashCode(dockingWindow2))) + "), '" + dockingWindow.getTitle() + "', " + (dockingWindow.isVisible() ? "visible" : "not visible") + ", " + (dockingWindow.isMaximized() ? "maximized" : "not maximized") + ", " + (dockingWindow.getChildWindowCount() > 0 ? ":" : ""));
        if (dockingWindow.getChildWindowCount() > 0) {
            printer.beginSection();
            for (int i = 0; i < dockingWindow.getChildWindowCount(); ++i) {
                if (dockingWindow.getChildWindow(i) == null) {
                    printer.println("null");
                    continue;
                }
                InternalDockingUtil.dump(dockingWindow.getChildWindow(i), printer);
            }
            printer.endSection();
        }
    }

    public static RootWindow createInnerRootWindow(View[] viewArray) {
        RootWindow rootWindow = DockingUtil.createRootWindow(new ViewMap(viewArray), true);
        rootWindow.getRootWindowProperties().getWindowAreaProperties().setBackgroundColor(null);
        rootWindow.getRootWindowProperties().getWindowAreaShapedPanelProperties().setComponentPainter(null);
        rootWindow.getRootWindowProperties().getComponentProperties().setBackgroundColor(null);
        rootWindow.getRootWindowProperties().getComponentProperties().setBorder(null);
        return rootWindow;
    }

    public static boolean updateButtons(ButtonInfo[] buttonInfoArray, AbstractButton[] abstractButtonArray, Container container, DockingWindow dockingWindow, PropertyMap propertyMap, Map map) {
        int n;
        boolean bl = false;
        for (n = 0; n < buttonInfoArray.length; ++n) {
            boolean bl2;
            WindowTabButtonProperties windowTabButtonProperties = new WindowTabButtonProperties(buttonInfoArray[n].getProperty().get(propertyMap));
            DockingWindowAction dockingWindowAction = windowTabButtonProperties.getAction();
            Map map2 = map == null ? null : (Map)map.get(windowTabButtonProperties.getMap());
            boolean bl3 = bl2 = windowTabButtonProperties.isVisible() && dockingWindowAction != null && dockingWindowAction.getAction(dockingWindow).isEnabled();
            if ((abstractButtonArray[n] == null || map2 != null && map2.containsKey(WindowTabButtonProperties.FACTORY)) && windowTabButtonProperties.getFactory() != null && dockingWindowAction != null) {
                abstractButtonArray[n] = windowTabButtonProperties.getFactory().createButton(dockingWindow);
                abstractButtonArray[n].setFocusable(false);
                abstractButtonArray[n].addActionListener(dockingWindowAction.getAction(dockingWindow).toSwingAction());
                bl = true;
            }
            if (abstractButtonArray[n] == null) continue;
            abstractButtonArray[n].setToolTipText(windowTabButtonProperties.getToolTipText());
            abstractButtonArray[n].setIcon(windowTabButtonProperties.getIcon());
            abstractButtonArray[n].setVisible(bl2);
        }
        if (bl && container != null) {
            container.removeAll();
            for (n = 0; n < buttonInfoArray.length; ++n) {
                if (abstractButtonArray[n] == null) continue;
                container.add(abstractButtonArray[n]);
            }
        }
        return bl;
    }

    public static void addToRootWindow(DockingWindow dockingWindow, RootWindow rootWindow) {
        if (rootWindow == null) {
            return;
        }
        DockingWindow dockingWindow2 = rootWindow.getWindow();
        if (dockingWindow2 == null) {
            rootWindow.setWindow(dockingWindow);
        } else if (dockingWindow2 instanceof TabWindow) {
            ((TabWindow)dockingWindow2).addTab(dockingWindow);
        } else {
            rootWindow.setWindow(new TabWindow(new DockingWindow[]{dockingWindow2, dockingWindow}));
        }
    }
}

