% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_to_df.R
\name{matrix_to_df}
\alias{matrix_to_df}
\title{Convert matrices to dataframe list for network}
\usage{
matrix_to_df(func_mat, str_mat)
}
\arguments{
\item{func_mat}{a square, symmetric matrix to be used as the main input
for the \code{\link{hms}} algorithm. For brain connectivity, this will be
a representation of functional (e.g., BOLD) connectivity.}

\item{str_mat}{a square, symmetric matrix to be used as the guidance
input for the \code{\link{hms}} algorithm. For brain connectivity, this 
will be a representation of structural (e.g., white matter) connectivity.}
}
\value{
A list containing the functional matrix, structural matrix, a data
frame of the functional edge weights, a data frame of the structural edge
weights, and nodal information (functional degree, structural degree,
community assignment, and label information)
}
\description{
Description of the convert matrices to data frame list for network function.
}
\details{
This is an ancillary function that creates a data frame list for the initial
network. This is the form of the network used for the spinglass algorithm
}
\examples{

# Using the example data SBM_net$func_matrix and SBM_net$str_mat
net <- matrix_to_df(SBM_net$func_mat, SBM_net$str_mat)
str(net)
identical(net, SBM_net)

}
