% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCohorts.R
\name{sampleCohorts}
\alias{sampleCohorts}
\title{Sample a cohort table for a given number of individuals.}
\usage{
sampleCohorts(cohort, cohortId = NULL, n, name = tableName(cohort))
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{n}{Number of people to be sampled for each included cohort.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
Cohort table with the specified cohorts sampled.
}
\description{
\code{sampleCohorts()} samples an existing cohort table for a given number of
people. All records of these individuals are preserved.
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(nPerson = 100)

cdm$cohort2 |> sampleCohorts(cohortId = 1, n = 10)
}
}
