% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireConceptIntersectFlag.R
\name{requireConceptIntersect}
\alias{requireConceptIntersect}
\title{Require cohort subjects to have (or not have) events of a concept list}
\usage{
requireConceptIntersect(
  cohort,
  conceptSet,
  window,
  intersections = c(1, Inf),
  cohortId = NULL,
  indexDate = "cohort_start_date",
  targetStartDate = "event_start_date",
  targetEndDate = "event_end_date",
  censorDate = NULL,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{conceptSet}{Concept set list.}

\item{window}{Window to consider events over.}

\item{intersections}{A range indicating number of intersections for
criteria to be fulfilled. If a single number is passed, the number of
intersections must match this.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged..}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{targetStartDate}{Date of reference in cohort table, either for start
(in overlap) or on its own (for incidence).}

\item{targetEndDate}{Date of reference in cohort table, either for end
(overlap) or NULL (if incidence).}

\item{censorDate}{Whether to censor overlap events at a specific date or a
column date of x.}

\item{name}{Name of the new cohort with the future observation restriction.}
}
\value{
Cohort table with only those  with the events in the concept list
kept (or those without the event if negate = TRUE)
}
\description{
\code{requireConceptIntersect()} filters a cohort table based on a requirement
that an individual is seen (or not seen) to have events related to a concept
list in some time window around an index date.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor(conditionOccurrence = TRUE)
cdm$cohort2 <-  requireConceptIntersect(
  cohort = cdm$cohort1,
  conceptSet = list(a = 1),
  window = c(-Inf, 0),
  name = "cohort2")
  }
}
