% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetCohorts.R
\name{subsetCohorts}
\alias{subsetCohorts}
\title{Generate a cohort table using a subset of cohorts from another table.}
\usage{
subsetCohorts(cohort, cohortId, name = tableName(cohort))
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{IDs of the cohorts to include. If NULL all cohorts will be
considered. Cohorts not included will be removed from the cohort set.}

\item{name}{Name of the new cohort with the demographic requirements.}
}
\value{
Cohort table with only cohorts in cohortId.
}
\description{
Generate a cohort table using a subset of cohorts from another table.
}
\examples{
\donttest{
library(CohortConstructor)

cdm <- mockCohortConstructor(nPerson = 100)

cdm$cohort1 |> subsetCohorts(cohortId = 1)
}
}
