% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCharacteristics.R
\name{summariseCharacteristics}
\alias{summariseCharacteristics}
\title{Summarise characteristics of cohorts in a cohort table}
\usage{
summariseCharacteristics(
  cohort,
  cohortId = NULL,
  strata = list(),
  counts = TRUE,
  demographics = TRUE,
  ageGroup = NULL,
  tableIntersectFlag = list(),
  tableIntersectCount = list(),
  tableIntersectDate = list(),
  tableIntersectDays = list(),
  cohortIntersectFlag = list(),
  cohortIntersectCount = list(),
  cohortIntersectDate = list(),
  cohortIntersectDays = list(),
  conceptIntersectFlag = list(),
  conceptIntersectCount = list(),
  conceptIntersectDate = list(),
  conceptIntersectDays = list(),
  otherVariables = character(),
  otherVariablesEstimates = c("min", "q25", "median", "q75", "max", "count",
    "percentage")
)
}
\arguments{
\item{cohort}{A cohort table in the cdm.}

\item{cohortId}{Vector of cohort definition ids to include. If NULL all
cohort will be selected.}

\item{strata}{A list of variables to stratify results. These variables
must have been added as additional columns in the cohort table.}

\item{counts}{TRUE or FALSE. If TRUE, record and person counts will
be produced.}

\item{demographics}{TRUE or FALSE. If TRUE, patient demographics (cohort
start date, cohort end date, age, sex, prior observation, and future
observation will be summarised).}

\item{ageGroup}{A list of age groups to stratify results by.}

\item{tableIntersectFlag}{A list of arguments that uses
PatientProfiles::addTableIntersectFlag() to add variables to summarise.}

\item{tableIntersectCount}{A list of arguments that uses
PatientProfiles::addTableIntersectCount() to add variables to summarise.}

\item{tableIntersectDate}{A list of arguments that uses
PatientProfiles::addTableIntersectDate() to add variables to summarise.}

\item{tableIntersectDays}{A list of arguments that uses
PatientProfiles::addTableIntersectDays() to add variables to summarise.}

\item{cohortIntersectFlag}{A list of arguments that uses
PatientProfiles::addCohortIntersectFlag() to add variables to summarise.}

\item{cohortIntersectCount}{A list of arguments that uses
PatientProfiles::addCohortIntersectCount() to add variables to summarise.}

\item{cohortIntersectDate}{A list of arguments that uses
PatientProfiles::addCohortIntersectDate() to add variables to summarise.}

\item{cohortIntersectDays}{A list of arguments that uses
PatientProfiles::addCohortIntersectDays() to add variables to summarise.}

\item{conceptIntersectFlag}{A list of arguments that uses
PatientProfiles::addConceptIntersectFlag() to add variables to summarise.}

\item{conceptIntersectCount}{A list of arguments that uses
PatientProfiles::addConceptIntersectCount() to add variables to summarise.}

\item{conceptIntersectDate}{A list of arguments that uses
PatientProfiles::addConceptIntersectDate() to add variables to summarise.}

\item{conceptIntersectDays}{A list of arguments that uses
PatientProfiles::addConceptIntersectDays() to add variables to summarise.}

\item{otherVariables}{Other variables contained in cohort that you want to be
summarised.}

\item{otherVariablesEstimates}{Name of the estimates for the otherVariables
columns.}
}
\value{
A summary of the characteristics of the cohorts in the cohort table.
}
\description{
Summarise characteristics of cohorts in a cohort table
}
\examples{
\donttest{
library(dplyr)
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

summariseCharacteristics(cohort = cdm$cohort1) |>
  glimpse()

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
