% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cohensdp.R
\name{Cohensdp}
\alias{Cohensdp}
\title{Cohen's standardized mean difference.}
\usage{
Cohensdp(statistics, design, gamma, method )
}
\arguments{
\item{statistics}{a list of pre-computed statistics. The statistics to provide
depend on the design:
- for "between": \code{m1}, \code{m2} the means of the two groups,
\code{s1}, \code{s2} the standard deviation of the two groups,
and \code{n1}, \code{n2}, the sample sizes of the two groups;
- for "within": \code{m1}, \code{m2}, \code{s1}, \code{s2}, \code{n}, and
\code{r} or \code{rho} the correlation between the measure;
- for "single": \code{m}, \code{s}, \code{n} and \code{m0} the reference mean
from which \code{m} is standardized).}

\item{design}{the design of the measures (\code{"within"}, \code{"between"}, or \code{"single"});}

\item{gamma}{the confidence level of the confidence interval (default 0.95)}

\item{method}{In "within"-subject design only, choose among methods \code{"piCI"}, or
\code{"adjustedlambdaprime"} (default), \code{"alginakeselman2003"}, \code{"morris2000"}, and
\code{"regressionapproximation"}.}
}
\value{
The Cohen's $d_p$ statistic and its confidence interval.
The return value is internally a dpObject which can be
displayed with print, explain or summary/summarize.
}
\description{
\code{Cohensdp()} computes the Cohen's d (noted $d_p$) and its confidence interval in
either within-subject, between-subject design and single-group design. For
the between-subject design, MBESS already has an implementation based on the
"pivotal" method but the present method is faster,
using the method based on the Lambda prime
distribution \insertCite{l07}{CohensdpLibrary}. See
\insertCite{h81,c22a,c22b,gc18;textual}{CohensdpLibrary}.
}
\details{
This function uses the exact method in "single"-group and "between"-subject designs.
In "within"-subject design, the default is the adjusted Lambda prime confidence interval
("adjustedlambdaprime") which is based on an approximate method. This method is described in
\insertCite{c22b;textual}{CohensdpLibrary}. Other methods are available, described in
\insertCite{m00,ak03,CG057-1,f22;textual}{CohensdpLibrary}
}
\examples{

# example in which the means are 114 vs. 101 with sds of 14.3 and 12.5 respectively
Cohensdp( statistics = list( m1= 101, m2= 114, s1= 12.5, s2= 14.3, n1= 12, n2= 12 ), 
          design     = "between")

# example in a repeated-measure design
Cohensdp(statistics =list( m1= 101, m2= 114, s1= 12.5, s2= 14.3, n= 12, rho= 0.53 ),
         design     ="within" )

# example with a single-group design where mu is a population parameter
Cohensdp( statistics = list( m = 101, m0 = 114, s = 12.5, n = 10 ), 
          design     = "single")

# The results can be displayed in three modes
res <- Cohensdp( statistics = list( m = 101, m0 = 114, s = 12.5, n = 10), 
                 design     = "single")

# a raw result of the Cohen's d_p and its confidence interval
res              

# a human-readable output
summarize( res ) 

# ... and a human-readable ouptut with additional explanations.
explain( res )   

# example in a repeated-measure design with a different method than piCI
Cohensdp(statistics =list( m1= 101, m2= 114, s1= 12.5, s2= 14.3, n= 12, r= 0.53 ),
         design     ="within", method = "adjustedlambdaprime")


}
\references{
\insertAllCited{}
}
