% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lprime.R
\name{lprime}
\alias{lprime}
\alias{dlprime}
\alias{plprime}
\alias{qlprime}
\title{Lambda prime or noncentral Lambda distribution.}
\usage{
plprime(x, nu, ncp) 
dlprime(x, nu, ncp)
qlprime(p, nu, ncp)
}
\arguments{
\item{x}{the score for which a probability is sought;}

\item{nu}{the degree of freedom of the distribution;}

\item{ncp}{the non-centrality parameter of the distribution;}

\item{p}{the probability from which a quantile is requested;}
}
\value{
\preformatted{     The probability or quantile of a Lambda' distribution.
}
}
\description{
plprime computes the cumulative probability of the lambda-prime distribution with
parameters nu, ncp. dlprime(x, nu, ncp)  returns the density of the lambda prime
and distribution qlprime(p, nu, ncp) its quantiles. See
\insertCite{l99;textual}{CohensdpLibrary}.
}
\details{
lprime are functions that compute the Lambda-prime distribution. It was shown to be the predictive
distribution of a population standardized mean or standardized mean difference in between-group design
given an observed Cohen's dp \insertCite{l07}{CohensdpLibrary}.

These functions are implemented from the FORTRAN source of \insertCite{pl10b;textual}{CohensdpLibrary}.
Note that the library sadists also implements this distribution sadists::lprime \insertCite{p20}{CohensdpLibrary}.
}
\examples{

dlprime(11.1, 9, 10.0) # 0.129447
plprime(11.1, 9, 10.0) # 0.7134134
qlprime(0.01, 9, 10.0) # 4.2453

}
\references{
\insertAllCited{}
}
