% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugCodes.R
\name{getATCCodes}
\alias{getATCCodes}
\title{Get descendant codes for ATC levels}
\usage{
getATCCodes(cdm, level = c("ATC 1st"), name = NULL, doseForm = NULL)
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{level}{ATC level. Can be one or more of "ATC 1st", "ATC 2nd",
"ATC 3rd", "ATC 4th", and "ATC 5th"}

\item{name}{ATC name of interest. For example, c("Dermatologicals",
"Nervous System"), would result in a list of length two with the descendant
concepts for these two particular ATC groups.}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}
}
\value{
A named list, with each element containing the descendant
concepts for a particular ATC group
}
\description{
Get descendant codes for ATC levels
}
\examples{
cdm <- mockVocabRef()
getATCCodes(cdm = cdm, level = "ATC 1st")
DBI::dbDisconnect(attr(cdm, "dbcon"), shutdown = TRUE)
}
