% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaPower.R
\name{ctmaPower}
\alias{ctmaPower}
\title{ctmaPower}
\usage{
ctmaPower(
  ctmaInitFit = NULL,
  activeDirectory = NULL,
  statisticalPower = c(),
  failSafeN = NULL,
  failSafeP = NULL,
  timeRange = NULL,
  useMBESS = FALSE,
  coresToUse = 1,
  digits = 4,
  indVarying = FALSE,
  activateRPB = FALSE,
  silentOverwrite = FALSE,
  loadAllInvFit = c(),
  saveAllInvFit = c(),
  loadAllInvWOSingFit = c(),
  saveAllInvWOSingFit = c(),
  skipScaling = TRUE,
  useSampleFraction = NULL,
  optimize = TRUE,
  nopriors = TRUE,
  finishsamples = NULL,
  iter = NULL,
  chains = NULL,
  verbose = NULL,
  customPar = TRUE
)
}
\arguments{
\item{ctmaInitFit}{object to which all single 'ctsem' fits of primary studies has been assigned to (i.e., what has been returned by \code{\link{ctmaInit}})}

\item{activeDirectory}{defines another active directory than the one used in \code{\link{ctmaInit}}}

\item{statisticalPower}{vector of requested statistical power values}

\item{failSafeN}{sample size used to determine across which time intervals effects become non-significant}

\item{failSafeP}{p-value used to determine across which time intervals effects become non-significant}

\item{timeRange}{vector describing the time range for x-axis as sequence from/to/stepSize (e.g., c(1, 144, 1))}

\item{useMBESS}{use 'MBESS' package to calculate statistical power (slower)}

\item{coresToUse}{if negative, the value is subtracted from available cores, else value = cores to use}

\item{digits}{number of digits used for rounding (in outputs)}

\item{indVarying}{Allows continuous time intercepts to vary at the individual level (random effects model, accounts for unobserved heterogeneity)}

\item{activateRPB}{set to TRUE to receive push messages with 'CoTiMA' notifications on your phone}

\item{silentOverwrite}{overwrite old files without asking}

\item{loadAllInvFit}{load the fit of fully constrained 'CoTiMA' model}

\item{saveAllInvFit}{save the fit of fully constrained 'CoTiMA' model}

\item{loadAllInvWOSingFit}{load series of fits of fully constrained 'CoTiMA' model with single cross effects excluded, respectively}

\item{saveAllInvWOSingFit}{save series of fits of fully constrained 'CoTiMA' model with single cross effects excluded, respectively}

\item{skipScaling}{does not (re-)scale raw data (re-scaling of imported pseudo raw data achieves correlations = 1)}

\item{useSampleFraction}{to speed up debugging. Provided as fraction (e.g., 1/10)}

\item{optimize}{if set to FALSE, Stan’s Hamiltonian Monte Carlo sampler is used (default = TRUE = maximum a posteriori / importance sampling) .}

\item{nopriors}{if TRUE, any priors are disabled – sometimes desirable for optimization}

\item{finishsamples}{number of samples to draw (either from hessian based covariance or posterior distribution) for final results computation (default = 1000).}

\item{iter}{number of iterations (defaul = 1000). Sometimes larger values could be required fom Bayesian estimation}

\item{chains}{number of chains to sample, during HMC or post-optimization importance sampling.}

\item{verbose}{integer from 0 to 2. Higher values print more information during model fit – for debugging}

\item{customPar}{logical. If set TRUE (default) leverages the first pass using priors and ensure that the drift diagonal cannot easily go too negative (helps since ctsem > 3.4)}
}
\value{
ctmaPower returns a list containing some arguments supplied, a fitted model with all (!) parameters invariant across primary
studies, different elements summarizing the main results, model type, and the type of plot that could be performed with the returned object.
The arguments in the returned object are activeDirectory, coresToUse, n.latent, n.manifest, and primaryStudyList. A further result
returned is n.studies = 1 (required for proper plotting). Further arguments, which are just copied from the init-fit object supplied, are,
n.latent, studyList, and the statisticsList. The fitted model is found in studyFitList, which is a large list with many elements (e.g., the
ctsem model specified by CoTiMA, the rstan model created by ctsem, the fitted rstan model etc.). Further results returned are  a list with
modelResults (i.e., DRIFT=DRIFT, DIFFUSION=DIFFUSION, T0VAR=T0VAR, CINT=NULL) and the paramter names internally used. The summary list,
which is printed if the summary function is applied to the returned object, contains "estimates", which is itself a list comprising
"Estimates of Model with all Effects Invariant", "Requested Statistical Power" (which just returns the argument statisticalPower),
"Power (post hoc) for Drift Effects",  "Required Sample Sizes" "Effect Sizes (based on discrete-time calcs; used for power calcs.)", and
"Range of significant effects" (across which intervals effects were significant). Plot type is plot.type=c("power") and model.type="stanct"
("omx" was deprecated).
}
\description{
Fits a full invariant model to a list of primary studies and performs analyses of expected (post hoc) power and required sample sizes.
}
\examples{
\dontrun{
CoTiMAInitFit_D_BO$activeDirectory <- "/Users/tmp/" # adapt!
CoTiMAPower_D_BO <- ctmaPower(ctmaInitFit=CoTiMAInitFit_D_BO,
                              statisticalPower = c(.50, .80, .95),
                              finishsamples = 10000)
summary(CoTiMAPower_D_BO)
}

}
