% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{sample.moments}
\alias{sample.moments}
\title{Estimation of sample moments}
\usage{
sample.moments(x, na.rm = FALSE, raw = T, central = T, coef = T, order = 1:4)
}
\arguments{
\item{x}{a numeric vector of values}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds}

\item{raw}{logical - calculate raw moments?}

\item{central}{logical - calculate central moments?}

\item{coef}{logical - calculate coeffitients (coeffitient of variation, skweness and kurtosis)?}

\item{order}{vector of integers - raw moment orders}
}
\description{
Estimation of sample moments
}
\examples{

library(CoSMoS)

x <- rnorm(1000)
sample.moments(x)

y <- rparetoII(1000, 10, .1)
sample.moments(y)

}
\keyword{moments}
