% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRRgradVE.R
\name{plotRRgradVE}
\alias{plotRRgradVE}
\title{Plotting of the Ratio of Relative Risks for Higher/Lower Latent Subgroups against Correlate of Risk Effect Size for Trichotomous Biomarkers}
\usage{
plotRRgradVE(outComputePower, outDir = NULL, legendText,
  extendedLeg = TRUE, xLegPos = 0.5, yLegPos = 0.5, ySep = 0.07,
  margin = c(7, 4, 3, 1))
}
\arguments{
\item{outComputePower}{either a list of lists containing output from \code{\link{computePower}} or a character vector specifying the \code{.RData} file(s) containing \code{\link{computePower}} output}

\item{outDir}{a character vector specifying path(s) to output \code{.RData} file(s), necessary if \cr\code{outComputePower} is a character vector. Default is \code{NULL}.}

\item{legendText}{a character vector specifying the entirety of the legend text. The order of the elements (i.e., parameter values) must match that of the \code{\link{computePower}} input parameters in order for legend labels to be accurate.}

\item{extendedLeg}{a logical value specifying if the extended legend with additional information about the control-to-case ratio, overall vaccine efficacy, number of cases, etc., is to be included. Default is \code{TRUE}.}

\item{xLegPos}{a number from \code{0} to \code{1} specifying the horizontal position of the extended legend, if applicable. A value of \code{0} produces text on the left side of the plot, \code{0.5} (default) produces text in the center, and \code{1} produces text on the right side.}

\item{yLegPos}{a number from \code{0} to \code{1} specifying the vertical position of the extended legend, if applicable. A value of \code{0} produces text at the bottom of the plot, \code{0.5} (default) produces text in the center, and \code{1} produces text at the top.}

\item{ySep}{a numeric value that specifies the spacing distance between lines in the extended legend, if applicable. Default is \code{0.7}.}

\item{margin}{a numeric vector of the form \code{c(bottom, left, top, right)}, which specifies the margins of the plot. Default is \code{c(7, 4, 3, 1)}.}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Plots the ratio of relative risks for the higher and lower latent subgroups (on the y-axis) versus the correlate of risk effect size (on the x-axis) in the active treatment group for a trichotomous biomarker.
The correlate of risk effect size is quantified as the relative risk ratio of the clinical endpoint comparing subgroups of active treatment recipients with high and low biomarker response.
}
\details{
When \code{rho} is varied, this plot shows how the relationship between the correlate of risk effect size and the relative risks for the higher and lower latent subgroups
changes for different values of \code{rho}. The ratio of relative risks for the higher and lower latent subgroups is a relative vaccine efficacy parameter. When \code{rho=1},
a correlate of risk in the vaccine group is equivalent to the relative vaccine efficacy parameter, whereas for imperfectly measured biomarkers with \code{rho<1},
the correlate of risk effect size is closer to the null than the relative vaccine efficacy parameter is.
}
\examples{
# Example scenario with trichotomous biomarker, where values of rho are varied

# Set input parameters for computePower function
nCasesTx <- 10
nControlsTx <- 300
nCasesTxWithS <- 10
controlCaseRatio <- 3
VEoverall <- 0.75
risk0 <- 0.034
VElat0 <- seq(0, VEoverall, len=10)
VElat1 <- rep(VEoverall, 10)
Plat0 <- P0 <- 0.2
Plat2 <- P2 <- 0.6
M <- 20
alpha <- 0.05
sigma2obs <- 1
rho <- c(1, 0.7, 0.4)
biomType <- "trichotomous"

# Output from computePower function is stored in an object as a list
pwr <- computePower(nCasesTx=nCasesTx, nControlsTx=nControlsTx, nCasesTxWithS=nCasesTxWithS,
                    controlCaseRatio=controlCaseRatio, risk0=risk0, VEoverall=VEoverall,
                    Plat0=Plat0, Plat2=Plat2, P0=P0, P2=P2, VElat0=VElat0,
                    VElat1=VElat1, M=M, alpha=alpha, sigma2obs=sigma2obs, rho=rho,
                    biomType=biomType)

# Set parameters for plotPowerCont function
# outComputePower is a list of lists containing output from the computePower function
outComputePower <- pwr
legendText <- paste0("rho = ", c(1, 0.7, 0.4))
plotRRgradVE(outComputePower=outComputePower, legendText=legendText)

\dontrun{
# Output from computePower function is saved in an RData file
computePower(..., saveDir = "myDir", saveFile = "myFile.RData")

# outComputePower is a character string specifying the file containing the computePower output
# outDir is a character string specifying the outComputePower file directory
outComputePower <- paste0("myFile_rho_", c(1, 0.7, 0.4), ".RData")
outDir <- "~/myDir"
legendText <- paste0("rho = ", c(1, 0.7, 0.4))
plotRRgradVE(outComputePower, outDir=outDir, legendText = legendText)
}

}
\seealso{
\code{\link{computePower}}, \code{\link{plotPowerTri}}
}
