% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{model.selection.R}
\alias{model.selection.R}
\title{Selection of both the number \eqn{K} of clusters and the subset \eqn{S} of clustering variables.
}

\usage{
model.selection.R(fileOrData, cte = as.double(1), alpha = as.double(2.0), header = TRUE,
  lines = integer())
}

\arguments{
\item{fileOrData}{A character string or a data frame (see \code{\link{backward.explorer}}). If \code{fileOrData} is a data frame,
it must contains a column named \code{logLik} and another named \eqn{dim} (see details).}

\item{cte}{A penalty function parameter. The associated criterion is \eqn{-log(likelihood)+cte*dim}.}

\item{alpha}{A coefficient in \eqn{[1.5,2]}. The default value is \eqn{2}.}

\item{header}{Indication of the presence of header in the file.}

\item{lines}{A vector of integer. If not empty and \code{fileOrData} is the name of a file, only models defined in \code{lines} are compared.}
}
\value{
A data frame of the selected models for the proposed penalized criteria.
}
\description{
The inference on both the number \eqn{K} of clusters and the subset \eqn{S} of clustering variables is seen as a model selection problem. Each competing model is characterized by one value of \eqn{\left(K,S\right)}. The competing models are compared using penalized criteria AIC, BIC, ICL and a more general penalized criterion with a penalty function on the form \deqn{pen\left(K,S\right)=\alpha*\lambda*dim\left(K,S\right),} where 
\itemize{
\item \eqn{\lambda} is a parameter that can be calibrated using "slope-heuristics" (see \code{\link{backward.explorer}}, \code{\link{dimJump.R}}),
\item and \eqn{\alpha} is a coefficient in \eqn{[1.5, 2]} to be given by the user.
}}

\seealso{
\code{\link{backward.explorer}}, \code{\link{dimJump.R}}.
}

\examples{
data(genotype2_ExploredModels)
outDimJump = dimJump.R(genotype2_ExploredModels, N = 1000, h = 5, header = TRUE)
cte1 = outDimJump[[1]][1]
outSlection = model.selection.R(genotype2_ExploredModels, cte = cte1, header = TRUE)
outSlection
}

\author{
Wilson Toussile
}

\references{
\itemize{
		\item  \href{http://projecteuclid.org/euclid.ejs/1379596773}{Dominique Bontemps and Wilson Toussile (2013)} : Clustering and 	variable selection for categorical multivariate data. Electronic Journal of Statistics, Volume 7, 2344-2371, ISSN.
		
		\item 	\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)} : Variable 	selection in model-based clustering using multilocus genotype data. Adv Data Anal Classif, Vol 3, number 2, 109-134.
	}
}

\keyword{Classification}
\keyword{Cluster}
\keyword{Slope-heuristics}
\keyword{Model selection}
\keyword{Penalized maximum log-likelihood}


