% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{cutEachCol}
\alias{cutEachCol}

\title{Retrieve data from strings in the dataset.}

\usage{
cutEachCol(xdata, ploidy)
}

\arguments{
\item{xdata}{A data.frame or a matrix of strings.}

\item{ploidy}{The number of unordered observations represented by a string in \code{xdata}. For example, for genotypic data from diploid individual, \eqn{ploidy = 2} : a data such as "ab" represents \code{\{"a", "b"\}} observed alleles.}
}

\value{
A matrix of strings compatible with the main functions of \code{\link{ClustMMDD}}. The number of columns in the outcome data frame is equal to 
\eqn{ploidy*ncol(xdata)}.
}

\description{
It is assumed that each string in the data frame submitted represents a set of \eqn{ploidy} unordered observations from the same set of levels. For example, for \eqn{ploidy = 2}, the data "101102" represents {"101", "102"}.
}

\author{
Wilson Toussile
}

\seealso{
\code{\link{dataR2C}} for \code{\link{ClustMMDD}} data format.
}

\examples{
data(genotype1)
head(genotype1) 
genotype2 = cutEachCol(genotype1[,-11], ploidy = 2)
head(genotype2)
}

\keyword{Genotype data}

